/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include <exception>            // Standard exception class
#include <stdexcept>            // logic_error and runtime_error
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>
#include <vector>
#include <set>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <map>
#include <glib.h>
#include <config.h>


using namespace std;


/*
*/


void replace_text (string& line, const string& look_for, const string& replace_with)
{
  size_t offposition = line.find (look_for);
  while (offposition != string::npos) {
    line.replace (offposition, look_for.length (), replace_with);
    offposition = line.find (look_for, offposition + replace_with.length ());
  }
}


int main (int argc, char *argv[])
{
  // Check whether we are searching.
  if (argc < 2)
    return 0;
  // Assemble grep command.
  string command = "grep -i -l '";
  string searchword = argv[1];
  searchword.erase (0, 2);
  command.append (searchword);
  command.append ("' ");
  command.append (PACKAGE_DATA_DIR);
  command.append ("/default/*.html");
  // Run grep and output results.
  FILE *stream;
  stream = popen (command.c_str (), "r");
  char buf[1024];
  bool succesfull = false;
  while (fgets (buf, sizeof (buf), stream)) {
    // Read a filename from grep.
    string filename = buf;
    filename.erase (filename.length() - 1, 1);
    // Extract the heading from the file
    string title = "Untitled";
    ifstream in (filename.c_str());
    string s;
    while (getline (in, s)) {
      if (s.find ("<h2") != string::npos) {
        size_t pos2 = s.find (">");
        pos2++;
        title = s.substr (pos2, s.length() - pos2 - 5);
        break;
      }
    }
    // Get basename for html linking.
    gchar * basename;
    basename = g_path_get_basename (filename.c_str());
    filename = basename;
    g_free (basename);
    // Output html code.
    if (filename != "allpages.html") {
      cout << "<h3><a href=\"" << filename << "\">" << title << "</a></h3>" << endl;
      succesfull = true;
    }
  }
  pclose (stream);
  // Indicate if nothing was found.
  if (!succesfull) {
    cout << "<p>No search results.</p>" << endl;
  }
  // Finish.
  return 0;
}
