/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGSELECTBOOKS_H
#define INCLUDED_DIALOGSELECTBOOKS_H


#include <gtk/gtk.h>
#include "generalconfig.h"


typedef enum
{ sbAdd, sbDelete, sbSearch, sbCheck, sbImport } SelectBookDialogActions;


class SelectBooksDialog
{
public:
  SelectBooksDialog (SelectBookDialogActions action,
                     const vector <ustring> &selectablebooks, set <ustring> & selection);
  ~SelectBooksDialog ();
  int run ();
protected:
  GtkWidget *selectbooksdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *hbox2;
  GtkWidget *hbox3;

  GtkWidget *vbox2;
  GtkWidget *treeview1;
  GtkWidget *label11;
  GtkWidget *vbox3;
  GtkWidget *treeview2;
  GtkWidget *label12;
  GtkWidget *vbox4;
  GtkWidget *treeview3;
  GtkWidget *label13;
  GtkWidget *vbox5;
  GtkWidget *treeview4;
  GtkWidget *label14;
  GtkWidget *vbox6;
  GtkWidget *treeview5;
  GtkWidget *label15;
  GtkWidget *vbox7;
  GtkWidget *treeview6;
  GtkWidget *label16;

  GtkWidget *label5;
  GtkWidget *hbox1;
  GtkWidget *nobutton;
  GtkWidget *alignment1;
  GtkWidget *hbox4;
  GtkWidget *image1;
  GtkWidget *label6;
  GtkWidget *otbutton;
  GtkWidget *alignment2;
  GtkWidget *hbox5;
  GtkWidget *image2;
  GtkWidget *label7;
  GtkWidget *ntbutton;
  GtkWidget *alignment3;
  GtkWidget *hbox6;
  GtkWidget *image3;
  GtkWidget *label8;
  GtkWidget *allbutton;
  GtkWidget *alignment4;
  GtkWidget *hbox7;
  GtkWidget *image4;
  GtkWidget *label9;
  GtkWidget *currentbutton;
  GtkWidget *alignment5;
  GtkWidget *hbox8;
  GtkWidget *image5;
  GtkWidget *label10;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
  set <ustring> * myselection;
  GeneralConfiguration genconfig;
  GtkListStore *store1;
  GtkListStore *store2;
  GtkListStore *store3;
  GtkListStore *store4;
  GtkListStore *store5;
  GtkListStore *store6;
  GtkTreeViewColumn *column1;
  GtkTreeViewColumn *column2;
  GtkTreeViewColumn *column3;
  GtkTreeViewColumn *column4;
  GtkTreeViewColumn *column5;
  GtkTreeViewColumn *column6;
  GtkTreeSelection *select1;
  GtkTreeSelection *select2;
  GtkTreeSelection *select3;
  GtkTreeSelection *select4;
  GtkTreeSelection *select5;
  GtkTreeSelection *select6;
  static void on_nobutton_clicked (GtkButton * button, gpointer user_data);
  void on_none_clicked ();
  static void on_otbutton_clicked (GtkButton * button, gpointer user_data);
  void on_ot_clicked ();
  static void on_ntbutton_clicked (GtkButton * button, gpointer user_data);
  void on_nt_clicked ();
  static void on_allbutton_clicked (GtkButton * button, gpointer user_data);
  void on_all_clicked ();
  static void on_currentbutton_clicked (GtkButton * button, gpointer user_data);
  void on_current_clicked ();
  static void on_okbutton_clicked (GtkButton * button, gpointer user_data);
  void on_ok_clicked ();
  static void selection_foreach_function (GtkTreeModel * model,
                                          GtkTreePath * path, GtkTreeIter * iter, gpointer data);
  void addselection (const ustring book);
  void initially_select_books ();
  void select_books (set<ustring> * bookselection, GtkTreeModel *store, GtkTreeSelection * selection, GtkWidget * widget);
};


#endif
