/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "gwrappers.h"
#include <libgen.h>
#include <glib.h>


ustring gw_build_filename (const ustring& part1, const ustring& part2)
// Wrapper for g_build_filename, to make programming easier.
{
  ustring filename;
  gchar *name;
  name = g_build_filename (part1.c_str(), part2.c_str(), NULL);
  filename = name;
  g_free (name);
  return filename;
}


ustring gw_build_filename (const ustring& part1, const ustring& part2, const ustring& part3)
{
  ustring filename;
  gchar *name;
  name = g_build_filename (part1.c_str(), part2.c_str(), part3.c_str(), NULL);
  filename = name;
  g_free (name);
  return filename;
}


ustring gw_build_filename (const ustring& part1, const ustring& part2, const ustring& part3, const ustring& part4)
{
  ustring filename;
  gchar *name;
  name = g_build_filename (part1.c_str(), part2.c_str(), part3.c_str(), part4.c_str(), NULL);
  filename = name;
  g_free (name);
  return filename;
}


ustring gw_build_filename (const ustring& part1, const ustring& part2, const ustring& part3, const ustring& part4, const ustring& part5)
{
  ustring filename;
  gchar *name;
  name = g_build_filename (part1.c_str(), part2.c_str(), part3.c_str(), part4.c_str(), part5.c_str(), NULL);
  filename = name;
  g_free (name);
  return filename;
}


void gw_message (const ustring& message)
{
  write (1, message.c_str(), strlen (message.c_str()));
  write (1, "\n", 1);
}


void gw_warning (const ustring& warning)
{
  g_warning ("%s", warning.c_str());
}


void gw_critical (const ustring& critical)
{
  g_critical ("%s", critical.c_str());
}


void gw_error (const ustring& error)
{
  g_error ("%s", error.c_str());
}


ustring gw_path_get_basename (const ustring& filename)
{
  ustring returnvalue;
  gchar * basename;
  basename = g_path_get_basename (filename.c_str());
  returnvalue = basename;
  g_free (basename);
  return returnvalue;  
}


ustring gw_path_get_dirname (const ustring& filename)
{
  ustring returnvalue;
  gchar * dirname;
  dirname = g_path_get_dirname (filename.c_str());
  returnvalue = dirname;
  g_free (dirname);
  return returnvalue;  
}


bool gw_find_program_in_path (const ustring& program)
/*
Before we just used the exit code of the unix which command, but as this does 
not properly work on BSD systems, like Mac OS X, and the OLPC doesn't
include the which command, we make our own wrapper for glib's version.
It returns true if "program" is an executable program.
*/
{
  gchar * result;
  result = g_find_program_in_path (program.c_str());
  if (result) {
    g_free (result);
    return true;
  }
  return false;
}
