#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#file constants_test.py

"""Test functions and classes in the LyX.constants module

Revision History:

2005-02-01 Gnter Milde first version with the unittest framework
"""

from unittest import TestCase, main 
import os

from LyX import constants
from LyX.constants import *


class constantsTests(TestCase):
    """Test settings in constants.py"""
    
    def test_LYXCMD(self):
        """is LYXCMD on the system path?"""
        cmd = LYXCMD.split()[0]
        self.assertEqual(0, os.system("which %s"%(cmd)), 
                         "'%s' not on path"%LYXCMD)
    
    def test_SYSTEM_DIR(self):
        """is SYSTEM_DIR valid?
        
        `man lyx` says: The  system  directory is determined by searching 
        for the file "chkconfig.ltx": We first test whether the specified 
        dir exists and second whether it contains "chkconfig.ltx".
        """
        self.failUnless(os.path.isdir(SYSTEM_DIR))
        self.failUnless(os.path.isfile(os.path.join(SYSTEM_DIR,
                                                    'chkconfig.ltx')),
                       "'%s' doesnot contain file chkconfig.ltx"%SYSTEM_DIR)
        
    def test_USER_DIR(self):
        """is USER_DIR valid?"""
        self.failUnless(os.path.isdir(USER_DIR))
        
    def test_LYXRC_FILE(self):
        """is LYXRC_FILE present?"""
        self.failUnless(os.path.isfile(LYXRC_FILE), 
                        "LYXRC_FILE '%s' not found"%LYXRC_FILE)
        
    def test_SERVERPIPE(self):
        """does SERVERPIPE match the system specification?
        
        Check Environment variable and LYXRC_FILE"""
        serverpipe = os.environ.get("LYXPIPE")
        if not serverpipe:
            for line in file(LYXRC_FILE):
                if line.startswith(r'\serverpipe'):
                    serverpipe = line.split()[1].strip("\"' \n")
        self.assertEqual(serverpipe, SERVERPIPE)

    # def test_LYX_OPTIONS(self):
    #     """LYX_OPTIONS will be tested together with filter_options()"""
    #     pass
    
    def test_setup(self):
        """setup() shall load a user config file and normalize paths
        
        Write a 'mock' config file
        Set RC_FILE.
        Call setup() and see whether the settings are recognized and normalized
        """
        testsettings = ['SERVERPIPE = "~/.lyxpipe"',
                        'LYXRC_FILE = "/usr/local/lyx/preferences"'
                       ]
        mock_rc_name = os.tempnam(None, 'lyxtest')
        constants.RC_FILE = mock_rc_name
        mock_rc = file(mock_rc_name, 'w')
        mock_rc.write("\n".join(testsettings))
        mock_rc.close()
        # call setup() to  evaluate the new RC_FILE
        setup()
        os.remove(mock_rc_name)
        # check for the new settings
        self.assertEqual(os.path.expanduser("~/.lyxpipe"),
                         constants.SERVERPIPE)
        self.assertEqual(os.path.abspath("/usr/local/lyx/preferences"),
                         constants.LYXRC_FILE)
        


if __name__ == '__main__':    #run tests if called from command-line
    main()
