#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4cvs on Mon Feb  6 00:01:16 2006

import wx

class AdvancedSettings(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: AdvancedSettings.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.sizer_6_staticbox = wx.StaticBox(self, -1, _("LyX"))
        self.sizer_5_staticbox = wx.StaticBox(self, -1, _("OpenOffice.org"))
        self.window_1 = OOoSettings(self, -1)
        self.window_2 = LyxSettings(self, -1)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: AdvancedSettings.__set_properties
        pass
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: AdvancedSettings.__do_layout
        sizer_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_6 = wx.StaticBoxSizer(self.sizer_6_staticbox, wx.HORIZONTAL)
        sizer_5 = wx.StaticBoxSizer(self.sizer_5_staticbox, wx.HORIZONTAL)
        sizer_5.Add(self.window_1, 0, wx.EXPAND, 0)
        sizer_4.Add(sizer_5, 0, wx.EXPAND, 0)
        sizer_6.Add(self.window_2, 1, 0, 0)
        sizer_4.Add(sizer_6, 0, wx.EXPAND, 0)
        self.SetSizer(sizer_4)
        sizer_4.Fit(self)
        # end wxGlade
        
    def setProperties(self,params):
        apply(self.window_1.setProperties,params[0])
        apply(self.window_2.setProperties,params[1])
        
    def getSettings(self):
        return self.window_1.getSettings(),self.window_2.getSettings()

# end of class AdvancedSettings


class LyxSettings(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: LyxSettings.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.label_5 = wx.StaticText(self, -1, _("LyX pipe name"))
        self.text_ctrl_1 = wx.TextCtrl(self, -1, "")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: LyxSettings.__set_properties
        self.text_ctrl_1.SetMinSize((180, 21))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: LyxSettings.__do_layout
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(self.label_5, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_2.Add(self.text_ctrl_1, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        self.SetSizer(sizer_2)
        sizer_2.Fit(self)
        # end wxGlade
        
    def setProperties(self,lyx_pipe):
        self.text_ctrl_1.SetValue( lyx_pipe )
        
    def getSettings(self):
        return (self.text_ctrl_1.GetValue(),)

# end of class LyxSettings


class OOoSettings(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: OOoSettings.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.sizer_3_staticbox = wx.StaticBox(self, -1, "")
        self.radio_btn_Pipe = wx.RadioButton(self, -1, _("Use a pipe"), style=wx.RB_GROUP)
        self.label_2 = wx.StaticText(self, -1, _("Pipe name"))
        self.Pipe_name = wx.TextCtrl(self, -1, _("OOo_pipe"))
        self.radio_btn_TCP = wx.RadioButton(self, -1, _("Use TCP/IP"))
        self.label_3 = wx.StaticText(self, -1, _("Port"))
        self.Port_value = wx.SpinCtrl(self, -1, "8100", min=1, max=50000)
        self.label_4 = wx.StaticText(self, -1, _("Host"), style=wx.ALIGN_RIGHT)
        self.Host_name = wx.TextCtrl(self, -1, _("localhost"))

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_RADIOBUTTON, self.onRadioPipe, self.radio_btn_Pipe)
        self.Bind(wx.EVT_RADIOBUTTON, self.onRadioTCP, self.radio_btn_TCP)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: OOoSettings.__set_properties
        pass
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: OOoSettings.__do_layout
        sizer_3 = wx.StaticBoxSizer(self.sizer_3_staticbox, wx.HORIZONTAL)
        grid_sizer_1 = wx.FlexGridSizer(3, 3, 3, 3)
        grid_sizer_1.Add(self.radio_btn_Pipe, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 20)
        grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.Pipe_name, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.radio_btn_TCP, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.Port_value, 0, 0, 0)
        grid_sizer_1.Add((1, 1), 0, 0, 0)
        grid_sizer_1.Add(self.label_4, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.Host_name, 0, wx.EXPAND, 0)
        grid_sizer_1.AddGrowableCol(2)
        sizer_3.Add(grid_sizer_1, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_3)
        sizer_3.Fit(self)
        # end wxGlade

    def onRadioPipe(self, event): # wxGlade: OOoSettings.<event_handler>
        self.Pipe_name.Enable()
        self.Port_value.Enable(False)
        self.Host_name.Enable(False)

    def onRadioTCP(self, event): # wxGlade: OOoSettings.<event_handler>
        self.Pipe_name.Enable(False)
        self.Port_value.Enable()
        self.Host_name.Enable()
        
    def setProperties(self,oo_con_type,oo_pipe,oo_host,oo_port):
        self.radio_btn_Pipe.SetValue(oo_con_type)
        self.radio_btn_TCP.SetValue(not oo_con_type)
        self.Pipe_name.SetValue(oo_pipe)
        self.Port_value.SetValue(oo_port)
        self.Host_name.SetValue(oo_host)
        if oo_con_type == 1:
            self.onRadioPipe(None)
        else:
            self.onRadioTCP(None)
            
    def getSettings(self):
        oo_con_type = int(self.radio_btn_Pipe.GetValue())
        oo_pipe = self.Pipe_name.GetValue()
        oo_port = self.Port_value.GetValue()
        oo_host = self.Host_name.GetValue()
        return oo_con_type,oo_pipe,oo_host,oo_port

# end of class OOoSettings


class Pref_Connection_Base(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Pref_Connection_Base.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.label_1 = wx.StaticText(self, -1, _("Select your preferred Word Processor"), style=wx.ALIGN_CENTRE)
        self.choiceWP = wx.RadioBox(self, -1, "", choices=[_("OpenOffice.org Writer"), _("Microsoft Word"), _("LyX"), _("None")], majorDimension=1, style=wx.RA_SPECIFY_COLS)
        self.cp = wx.CollapsiblePane(self, -1, label=_("Advanced settings"))

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_RADIOBOX, self.onWPchoice, self.choiceWP)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: Pref_Connection_Base.__set_properties
        self.label_1.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD, 0, ""))
        self.choiceWP.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Pref_Connection_Base.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(self.label_1, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_1.Add(self.choiceWP, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_1.Add(self.cp, 1, wx.LEFT|wx.RIGHT|wx.EXPAND, 60)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        # end wxGlade

    def onWPchoice(self, event): # wxGlade: Pref_Connection_Base.<event_handler>
        print "Event handler `onWPchoice' not implemented!"
        event.Skip()

# end of class Pref_Connection_Base


class Pref_Connection(Pref_Connection_Base):
    def __init__(self, parent , id, ((wp_type,),(oo_con_type,oo_pipe,oo_host,oo_port),(lyx_pipe,)) ):
        Pref_Connection_Base.__init__(self, parent , id)
        # setting values according to current settings
        if wp_type == 'OOo':
            self.choiceWP.SetSelection(0)
        elif wp_type == 'mswDoc':
            self.choiceWP.SetSelection(1)
        elif wp_type == 'Lyx':
            self.choiceWP.SetSelection(2)
        else:
            self.choiceWP.SetSelection(3)    # None
        #
        self.OOoSettings = AdvancedSettings( self.cp.GetPane() )
        self.OOoSettings.setProperties( ((oo_con_type,oo_pipe,oo_host,oo_port),(lyx_pipe,)) )
        self.__setPossible()
        self.onWPchoice(None)
        
    def __setPossible(self):
        """Activate/Desactivate Word processor choices depending on python packages installed"""
        try:
            import uno
        except ImportError:
            self.choiceWP.EnableItem(0,False)
        #
        try:
            import win32com
        except ImportError:
            self.choiceWP.EnableItem(1,False)
        #
        if  wx.Platform == '__WXMSW__':
            self.choiceWP.EnableItem(2,False)   # LyX pipe only work under linux
        #
        if not self.choiceWP.IsItemEnabled( self.choiceWP.GetSelection() ):
            self.choiceWP.SetSelection(3)

    def onWPchoice(self, event): # wxGlade: Pref_Connection.<event_handler>
        """Activate/inactivate OOo and LyX setting panel"""
        self.cp.Enable( self.choiceWP.GetStringSelection() in ("OpenOffice.org Writer","LyX") )
        
    def getSettings(self):
        if self.choiceWP.GetSelection() == 0:
            wp_type = 'OOo'
        elif self.choiceWP.GetSelection() == 1:
            wp_type = 'mswDoc'
        elif self.choiceWP.GetSelection() == 2:
            wp_type = 'Lyx'
        else:
            wp_type =''
        return ((wp_type,),) + self.OOoSettings.getSettings()

# end of class Pref_Connection


