/** 
 * @namespace   biew_plugins_auto
 * @file        plugins/bin/pe.h
 * @brief       This file contains PE executable file definitions.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#ifndef __PE_INC
#define __PE_INC

#ifndef __SYS_DEP_H
#include "_sys_dep.h"
#endif

#ifdef __HAVE_PRAGMA_PACK__
#pragma pack(1)
#endif

/* Portable EXE header */
typedef struct tagPEHEADER
{
  uint8_t    peSignature[4];        /**< 'PE\00\00' */
  uint16_t   peCPUType;
  uint16_t   peObjects;
  uint32_t   peTimeDataStamp;
  uint32_t   peReserv1;
  uint32_t   peReserv2;
  uint16_t   peNTHdrSize;
  uint16_t   peFlags;
  uint16_t   peReserv3;
  uint8_t    peLMajor;
  uint8_t    peLMinor;
  uint32_t   peReserv4;
  uint32_t   peReserv5;
  uint32_t   peReserv6;
  uint32_t   peEntryPointRVA;
  uint32_t   peReserv7;
  uint32_t   peReserv8;
  uint32_t   peImageBase;
  uint32_t   peObjectAlign;
  uint32_t   peFileAlign;
  uint16_t   peOSMajor;
  uint16_t   peOSMinor;
  uint16_t   peUserMajor;
  uint16_t   peUserMinor;
  uint16_t   peSubSystMajor;
  uint16_t   peSubSystMinor;
  uint32_t   peReserv9;
  uint32_t   peImageSize;
  uint32_t   peHeaderSize;
  uint32_t   peFileChecksum;
  uint16_t   peSubSystem;
  uint16_t   peDLLFlags;
  uint32_t   peStackReserveSize;
  uint32_t   peStackCommitSize;
  uint32_t   peHeapReserveSize;
  uint32_t   peHeapCommitSize;
  uint32_t   peReserv10;
  uint32_t   peInterestingVASize;
  uint32_t   peExportTableRVA;
  uint32_t   peTotalExportDataSize;
  uint32_t   peImportTableRVA;
  uint32_t   peTotalImportDataSize;
  uint32_t   peResourceTableRVA;
  uint32_t   peTotalResourceDataSize;
  uint32_t   peExceptionTableRVA;
  uint32_t   peTotalExceptionDataSize;
  uint32_t   peSecurityTableRVA;
  uint32_t   peTotalSecurityDataSize;
  uint32_t   peFixupTableRVA;
  uint32_t   peTotalFixupDataSize;
  uint32_t   peDebugTableRVA;
  uint32_t   peTotalDebugDirectories;
  uint32_t   peImageDescriptionRVA;
  uint32_t   peTotalDescriptionSize;
  uint32_t   peMachineSpecificRVA;
  uint32_t   peMachineSpecificSize;
  uint32_t   peThreadLocalStorageRVA;
  uint32_t   peTotalTLSSize;
}PEHEADER;

typedef struct tagPE_ADDR
{
 uint32_t rva;
 uint32_t phys;
}PE_ADDR;

typedef struct tagExportTablePE
{
  uint32_t etFlags;
  uint32_t etDateTime;
  uint16_t etMajVer;
  uint16_t etMinVer;
  uint32_t etNameRVA;
  uint32_t etOrdinalBase;
  uint32_t etNumEATEntries;
  uint32_t etNumNamePtrs;
  uint32_t etAddressTableRVA;
  uint32_t etNamePtrTableRVA;
  uint32_t etOrdinalTableRVA;
}ExportTablePE;

typedef struct tagImportDirPE
{
  uint32_t idFlags;
  uint32_t idDateTime;
  uint16_t idMajVer;
  uint16_t idMinVer;
  uint32_t idNameRVA;
  uint32_t idLookupTableRVA;
}ImportDirPE;

typedef struct tagPE_OBJECT
{
  int8_t   oName[8];
  uint32_t oVirtualSize;
  uint32_t oRVA;
  uint32_t oPhysicalSize;
  uint32_t oPhysicalOffset;
  uint32_t oRelocPtr;
  uint32_t oLineNumbPtr;
  uint16_t oNReloc;
  uint16_t oNLineNumb;
  uint32_t oFlags;
}PE_OBJECT;

#ifdef __HAVE_PRAGMA_PACK__
#pragma pack()
#endif

#endif
