/** 
 * @namespace   biew
 * @file        tstrings.h
 * @brief       This file contains start of work for NLS support by BIEW.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#ifndef __TSTRINGS__H
#define __TSTRINGS__H

/** @def BIEW_VERSION
    Ver.SubVer.ExtraVer-ReleaseLevel.Test_FixPak_Level 
  */
#define BIEW_VERSION "5.2.0"

extern const char   msgUndef[];
extern const char   msgFatalError[];
extern const char * msgCritExitCause[];
extern const char * msgCritExit[];
extern const char * msgAsmErrList[];
extern const char * msgTypeComments[];
extern const char * msgComputerErrors[];
extern const char * msgHardPlace[];
extern const char   msgAboutText[];
extern const char * BiewPicture[];
extern const char * CompPicture[];
extern const char * MBoardPicture[];
extern const char * BitStreamPicture[];
extern const char * ConnectorPicture[];
extern const char * BiewerPicture[];
extern const char * BiewerScreenPicture[];
extern const char * CompScreenPicture[];
extern const char * msgWinCompat[];
extern const char * msgHeadDesc[];
extern const char * msgFindOpt[];

#if defined(__WIN32__) && defined(_MSC_VER)
  #define BIEW_VER_MSG          " Binary Viewer v "BIEW_VERSION"-i386.Win32 Build: " __DATE__ " "
#else
  #define BIEW_VER_MSG          " Binary Viewer v "BIEW_VERSION"-"__CPU_NAME__"."__OS_NAME__" Build: "__DATE__" "
#endif

#define UNDEFINE               "Undefined"
#define FATAL_ERROR            " *** FATAL ERROR *** : "

#define ISR_JUMP               " Jump to ISR "
#define INT_NUMBER             " Number of interrupt : "
#define GO_ABS_SHIFT           " Go to absolute shift "
#define GO_REL_SHIFT           " Go to relative shift "
#define TYPE_SHIFT             "Type new shifts : "
#define DIG_EVALUTOR           " Digital evaluator (hexadecimal) "
#define DIG_OPERATORS          " Known Operators - ()+-*/% ~|&^ "
#define EXPRESSION             "Expression:"
#define RESULT                 "Result:"
#define TYPE_HEX_FORM          "Type desired parameters in hexadecimal form:"
#define FILE_PRMT              "File :"
#define START_PRMT             "Start:"
#define LENGTH_PRMT            "Length :"
#define INIT_MASK              " Initialize mask "
#define INPUT_MASK             "Input new value of XX:"
#define ASM_HEAD               " 80686/80687 assembler (242/75 instructions mnemomics) [debug release!!!] "
#define ERROR_MSG              " Error "
#define WARN_MSG               " Warning "
#define NOTE_MSG               " Note "

#define HOW_SEE                " How to see "

#define NOT_ENTRY              "Entry not found"
#define BAD_ENTRY              " Bad entry "
#define NO_ENTRY               "Entry do not refers to physical page of this file"
#define UNK_SIGNATURE          "Unknown type of signature : "
#define UNK_HEADER             " Unknown header "
#define MOD_REFER              " Detected Module References : "
#define EXT_REFER              " External Refernces : "
#define EXP_TABLE              " Export Table : "
#define RES_NAMES              " Resident Names : "
#define NORES_NAMES            " Non Resident Names : "
#define IMPPROC_TABLE          " Import Procedures Table : "
#define CORRUPT_BIN_MSG        "??? *** Binary format is corrupt or internal error *** ???"

#define BACKWARD               "Backward"
#define FORWARD                "Forward "
#define FIND_STR               " Find string "
#define TYPE_STR               "Type string to search (for control letters hold ALT down + NumPads)"
#define FIND_PRMT              " [F2] - Case [F3] - Word [F4] - Scan "
#define PLEASE_WAIT            "Please wait ... "
#define SEARCHING              " Searching "
#define STR_NOT_FOUND          "String not found"
#define SEARCH_MSG             " Search "
#define SYS_INFO               " System information"
#define CPU_INFO               " CPU information "
#define PLEASE_WAIT12          "Please wait 1 - 2 sec..."

#define PAGEBOX_SUB            " [PgUp]/[PgDn] - Move  [ENTER] - Go Entry "
#define SPAGEBOX_SUB           " [PgUp]/[PgDn] - Move "

#define NAME_OF_EXP_FILE       " Name of export file "
#define NAME_MSG               " Name : "
#define ACCESS_DENIED          " Access denied "

#endif
