/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/csystem.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 20 08:45:23 1993                          */
/*    Last change :  Wed Mar 31 13:39:53 2004 (serrano)                */
/*    Copyright   :  2002-04 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    System interface                                                 */
/*=====================================================================*/
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef _MINGW_VER
#  define _BGL_WIN32_VER
#  include <io.h>
#  include <winsock2.h>
#  define lstat stat
#else
#  ifdef _MSC_VER
#    define _BGL_WIN32_VER
#    include <io.h>
#    include <winsock2.h>
#    define lstat stat
#  else
#    include <unistd.h>
#    include <sys/socket.h>
#    include <netinet/in.h>
#    include <arpa/inet.h>
#    include <netdb.h>
#  endif
#endif
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    La table des handlers de signaux                                 */
/*---------------------------------------------------------------------*/
static obj_t handler[ 32 ];

/*---------------------------------------------------------------------*/
/*    get_handler ...                                                  */
/*---------------------------------------------------------------------*/
static obj_t
get_handler( int num ) {
   /* Re-install the signal handler because some OS (such as Solaris) */
   /* de-install it when the signal is raised.                        */
   signal( num, (void (*)( int ))(get_handler) );
   return ((obj_t (*)())PROCEDURE_ENTRY(handler[ num ]))( handler[ num ],
                                                          BINT( num ),
                                                          BEOA );
}
    
/*---------------------------------------------------------------------*/
/*    obj_t ...                                                        */
/*---------------------------------------------------------------------*/
obj_t
c_signal( int sig, obj_t thunk ) {
   /* on met le thunk dans la table des handlers */
   handler[ sig ] = thunk;

   /* on le signale ... */
   signal( (int)sig, (void (*)( int ))get_handler );

   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    get_signal_handler ...                                           */
/*---------------------------------------------------------------------*/
obj_t
get_signal_handler( int sig ) {
   return PROCEDUREP( handler[ sig ] ) ? handler[ sig ] : BFALSE;
}

/*---------------------------------------------------------------------*/
/*    c_date ...                                                       */
/*---------------------------------------------------------------------*/
char *
c_date() {
#if( defined( sony_news ) )
   long now;
#else      
   time_t now;
#endif

   now = time( 0L );
   return ctime( &now );
}
      
/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_last_modification_time ...                                   */
/*---------------------------------------------------------------------*/
long
bgl_last_modification_time( char *file ) {
   struct stat _stat;

   if( lstat( file, &_stat ) )
      return -1;
   else
      return (long)(_stat.st_mtime);
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_size ...                                                */
/*---------------------------------------------------------------------*/
long
bgl_file_size( char *file ) {
   struct stat _stat;

   if( lstat( file, &_stat ) )
      return -1;
   else
      return _stat.st_size;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_chmod ...                                                    */
/*---------------------------------------------------------------------*/
int
bgl_chmod( char *file, int read, int write, int exec ) {
# ifndef _BGL_WIN32_VER
    return chmod( file,
                  (read ? S_IRUSR : 0) |
                  (write ? S_IWUSR : 0) |
                  (exec ? S_IXUSR : 0) );
# else
    return _chmod( file,
                   (read ? S_IREAD : 0) |
                   (write ? S_IWRITE : 0) );
# endif
}
		 
/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_setenv ...                                                   */
/*---------------------------------------------------------------------*/
int
bgl_setenv( char *id, char *val ) {
   size_t l1 = strlen( id ), l2 = strlen( val );
   char *s = malloc( l1 + l2 + 2 );
   
   strcpy( s, id );
   s[ l1 ] = '=';
   strcpy( &s[ l1 + 1 ], val );

   return putenv( s );
}

/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    bgl_gethostname ...                                              */
/*---------------------------------------------------------------------*/
char *
bgl_gethostname() {
#define MAXHOSTNAME 1024   
   static char h[ MAXHOSTNAME ];
   struct hostent *hp;
   
   gethostname( h, MAXHOSTNAME );
   hp = gethostbyname( h );

   return hp ? hp->h_name : "localhost";
#undef MAXHOSTNAME
}
