
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/byte-code.sch           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 25 09:12:35 1994                          */
;*    Last change :  Tue Oct 11 17:50:18 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les macros utiles pour la compilation et l'interpretation du     */
;*    byte-code                                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    evcode? ...                                                      */
;*---------------------------------------------------------------------*/
(define-macro (evcode? exp)
   `(vector? ,exp))

;*---------------------------------------------------------------------*/
;*    evcode ...                                                       */
;*---------------------------------------------------------------------*/
(define-macro (evcode op loc . args)
   `(vector ,op ,loc ,@args))

;*---------------------------------------------------------------------*/
;*    evcode-op ...                                                    */
;*---------------------------------------------------------------------*/
(define-macro (evcode-op ec)
   `(vector-ref ,ec 0))

;*---------------------------------------------------------------------*/
;*    evcode-op-set! ...                                               */
;*---------------------------------------------------------------------*/
(define-macro (evcode-op-set! ec op)
   `(vector-set! ,ec 0 ,op))

;*---------------------------------------------------------------------*/
;*    evcode-loc ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (evcode-loc ec)
   `(vector-ref ,ec 1))

;*---------------------------------------------------------------------*/
;*    list->evcode ...                                                 */
;*---------------------------------------------------------------------*/
(define-macro (list->evcode op loc lst)
   `(apply vector ,op ,loc ,lst))

;*---------------------------------------------------------------------*/
;*    evcode-length ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (evcode-length ec)
   `(-fx (vector-length ,ec) 2))

;*---------------------------------------------------------------------*/
;*    evcode-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (evcode-ref ec o)
   (if (fixnum? o)
       `(vector-ref ,ec ,(+fx o 2))
       `(vector-ref ,ec (+fx ,o 2))))

;*---------------------------------------------------------------------*/
;*    evcode-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-macro (evcode-set! ec o nv)
   (if (fixnum? o)
       `(vector-set! ,ec ,(+fx o 2) ,nv)
       `(vector-set! ,ec (+fx ,o 2) ,nv)))
