
int zone_load_errors = 0;

/* int
 * db_load(filename, in_origin, zp, def_domain, isixfr)
 *   wrapper for the db_load function, which will store the zone load error
 *   count in a global zone_load_errors variable.
 * returns:
 *	-1 = can't open file
 *	0 = success
 *	>0 = number of errors encountered
 */
int
db_load(const char *filename, const char *in_origin,
	struct zoneinfo *zp, const char *def_domain, int isixfr)
{
	int result;
	result = _db_load(filename, in_origin, zp, def_domain, isixfr);
	zone_load_errors += (result == -1) ? 1 : result;
	return result;
}

