/* makemake.c DOS|UNIX */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

struct 
{
  char *os;
  char *sifeq1;
  char *sifeq2;
  char *sifeq3;
  char *selse;
  char *sendif;
} def[] = {
  { "DOS", "!if ", " == \"", "\"", "!else", "!endif" },
  { "UNIX", "ifeq (", ",", ")", "else", "endif" }
};

main(int argc, char *argv[])
{
  enum {DOS=0,UNIX=1} os;
  char buf[256];
  char *ptr1, *ptr2;
  
  if (argc != 2) {
    fprintf(stderr, "Error: wrong number of arguments\n");
    exit(1);
  }
  
  if (!strcmp(argv[1], "dos"))
    os=DOS;
  else
    os=UNIX;
  
  while (fgets(buf, sizeof(buf), stdin) != NULL) {
    if (!strncmp(buf, "ifeq", 4)) {
      *(ptr1 = strchr(buf, ' ')) = 0;
      ptr1++;
      *(ptr2 = strchr(ptr1, ' ')) = 0;
      ptr2++;
      *(strchr(ptr2, '\n')) = 0;
      printf("%s%s%s%s%s\n", def[os].sifeq1, ptr1, def[os].sifeq2, ptr2, def[os].sifeq3);
    } else if (!strncmp(buf, "else", 4))
      printf("%s\n", def[os].selse);
    else if (!strncmp(buf, "endif", 5))
      printf("%s\n", def[os].sendif);
    else if ((ptr1 = strstr(buf, "@OS")) != NULL) {
      *ptr1=0;
      printf("%s%s%s", buf, def[os].os, ptr1 + 3);
    } else
      printf("%s", buf);
  }
}

    
	 
