/* (PD) 2001 The Bitzi Corporation
 * Please see file COPYING or http://bitzi.com/publicdomain 
 * for more info.
 *
 * $Id: skel.c,v 1.3 2002/01/13 02:53:44 mlinksva Exp $
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>

#include "plugin.h"
#include "sha1.h"
#include "bitcollider.h"

/*-------------------------------------------------------------------------*/

PluginMethods           *init_plugin(void);
static void              skel_shutdown_plugin(void);
static void              skel_free_attributes(Attribute *attrList);
static SupportedFormat  *skel_get_supported_formats(void);
static const char       *skel_get_name(void);
static const char       *skel_get_version(void);
static char             *skel_get_error(void);

/* Use EITHER the file_analyze function, or the init/update/final functions,
   depending on whether you want to use the file or memory interface for
   this plugin. */
static Attribute        *skel_file_analyze(const char *fileName); 

/* OR */

static Context          *skel_analyze_init(void);
static void              skel_analyze_update(Context            *context, 
                                            const unsigned char *buf,
                                            unsigned             bufLen);
static Attribute        *skel_analyze_final(Context *context);


/*-------------------------------------------------------------------------*/

#define PLUGIN_VERSION "1.0.0"
#define PLUGIN_NAME    "XYZ file information"

/* The NUM_ATTRS define must be set to the number of attributes this 
   plugin returns PLUS ONE! The main bitcollider will walk through the
   attributes and stop when it reaches an attribute with a NULL key.
   This plugin is responsible for setting the last key/value pair to
   NULL before they are returned to the bitcollider */
#define NUM_ATTRS      2   

/*-------------------------------------------------------------------------*/

typedef int            int32;
typedef unsigned       uint32;
typedef short          int16;
typedef unsigned short uint16;

typedef struct _SkelContext
{
   // Use the SkelContext struct to store any values that are needed
   // between the init/update/final calls


} SkelContext;

/*-------------------------------------------------------------------------*/

static SupportedFormat formats[] =
{ 
     { ".XYZ", "XYZ format"       },
     { NULL,   NULL               }
};
static char *errorString = NULL;

static PluginMethods methods = 
{
    skel_shutdown_plugin,
    skel_get_version,
    skel_get_name,
    skel_get_supported_formats,
    NULL, /* skel_file_analyze, */
    skel_analyze_init, 
    skel_analyze_update,
    skel_analyze_final,
    skel_free_attributes,
    skel_get_error
};

/*-------------------------------------------------------------------------*/

PluginMethods *init_plugin(void)
{
    return &methods;
}

static void skel_shutdown_plugin(void)
{
    if (errorString)
       free(errorString);
}

static const char *skel_get_version(void)
{
    return PLUGIN_VERSION;
}

static const char *skel_get_name(void)
{
    return PLUGIN_NAME;
}

static SupportedFormat *skel_get_supported_formats(void)
{
    return formats;
}

static Context *skel_analyze_init(void)
{
    SkelContext *context;

    context = malloc(sizeof(SkelContext));
    memset(context, 0, sizeof(SkelContext));

    return (Context *)context;
}

static void skel_analyze_update(Context             *contextArg, 
                                const unsigned char *buf,
                                unsigned             bufLen)
{
    SkelContext *context = (SkelContext *)contextArg;

}

static Attribute *skel_analyze_final(Context *contextArg)
{
    SkelContext    *context = (SkelContext *)contextArg;
    Attribute     *attrList;

    attrList = malloc(sizeof(Attribute) * NUM_ATTRS);
    memset(attrList, 0, sizeof(Attribute) * NUM_ATTRS);

    attrList[0].key = strdup("<attribute name>");
    attrList[0].value = strdup("<attribute value>");

    /* Set the last key/value pair to NULL so that the bitcollider 
       knows when to stop reading attributes */
    attrList[1].key = NULL;
    attrList[1].value = NULL;

    /* fill out any remaining tag attribute/value pairs here */

    return attrList;
}

static void skel_free_attributes(Attribute *attrList)
{
    int i;

    for(i = 0; i < NUM_ATTRS; i++)
    {
       if (attrList[i].key)
          free(attrList[i].key);
       if (attrList[i].value)
          free(attrList[i].value);
    }

    free(attrList);
}

static char *skel_get_error(void)
{
    return errorString;
}

