// -*- mode:C++; tab-width:4; c-basic-offset:2; indent-tabs-mode:nil -*- 
// Copyright 1999 Jose M. Vidal
// Jose M. Vidal, vidal@multiagent.com, http://jmvidal.ece.sc.edu
//
// This program is free software.  You can redistribute it and/or modify
// it under the terms of the GNU General Public License
//
// A simple XML-like parser, extended to handle HTML.
//
// $Id: XMLParser.H,v 1.4 2001/07/25 20:49:53 jmvidal Exp $

#ifndef XMLPARSER_H 
#define XMLPARSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <string>
#include <vector>
#include <map>

#include "iwebstream.H"
#include "reference.H"

using namespace std;

class XMLParser {
public:
	string doctype;
public:
  XMLParser() : doctype("") {};
  virtual ~XMLParser() {};
  virtual void startTag(string &tagName, map<string,string> & attributes);
  string toUpper(const string &s);
  virtual void endTag(string &tagName);
  virtual void cdata(string &content);
  void parse(iwebstream &in);
  string toString(string &tagname, map<string,string> & attributes);
};

class BookmarksParser : public XMLParser {
	vector<referenceTree *> rtStack;
	vector<reference *> refStack;
	referenceTree * root;
	bool inReference;
	bool inTitle;
	bool inComment;
	reference * currentReference;
	referenceTree * currentReferenceTree;
	
public:
	BookmarksParser() {
		currentReference = 0;
		currentReferenceTree = 0;
		root = 0;
		inReference = false;
		inTitle = false;
		inComment = false;
	};

	BookmarksParser(referenceTree * r) {
		currentReference = 0;
		currentReferenceTree = 0;
		root = 0;
		inReference = false;
		inTitle = false;
		inComment = false;
		root = r;
	};
	
	void startTag(string &tagName, map<string,string> & attributes);
	void endTag(string &tagName);
	void cdata(string &content);
	void endReference();
	referenceTree * getReferenceTree(){
		if (root == 0) {
			cerr << "ERROR: nothing was parsed" << endl;
			return 0;
		}
		return root;
	}
	
};


class RSSParser : public XMLParser {
  referenceTree * root;
  bool inItem;
  bool inTitle;
  bool inDescription;
  bool inLink;
  reference * currentReference;
	
public:
  RSSParser() {
    root = 0;
    inItem = false;
    inTitle = false;
    inDescription = false;
    inLink = false;
    currentReference = 0;
  };

  RSSParser(referenceTree * r) {
    inItem = false;
    inTitle = false;
    inDescription = false;
    inLink = false;
    currentReference = 0;
    root = r;
  };
	
  void startTag(string &tagName, map<string,string> & attributes);
  void endTag(string &tagName);
  void cdata(string &content);
  void endReference();
  referenceTree * getReferenceTree(){
    if (root == 0) {
      cerr << "ERROR: nothing was parsed" << endl;
      return 0;
    }
    return root;
  }
	
};



class XBELParser : public XMLParser {

  vector<referenceTree *> rtStack;
  vector<reference *> refStack;
  referenceTree * root;
  reference * currentBookmark;
  reference * currentFolder;
  referenceTree * currentReferenceTree;
  bool inBookmark;
  bool inFolder;
  bool inDesc;
  bool inTitle;
	
public:

  XBELParser() {
    currentBookmark = 0;
    currentFolder = 0;
    root = 0;
    currentReferenceTree = 0;
    inBookmark = false;
    inFolder = false;
    inDesc = false;
    inTitle = false;
  };
  
  XBELParser(referenceTree * r) {
    currentBookmark = 0;
    currentFolder = 0;
    root = r;
    currentReferenceTree = r;
    rtStack.push_back(r);
    root = 0;
    inBookmark = false;
    inFolder = false;
    inDesc = false;
    inTitle = false;
  };
	
  void startTag(string &tagName, map<string,string> & attributes);
  void endTag(string &tagName);
  void cdata(string &content);
  void endReference();
  referenceTree * getReferenceTree(){
    if (root == 0) {
      cerr << "ERROR: nothing was parsed" << endl;
      return 0;
    }
    return root;
  }
	
};



class FolderCommentParser : public XMLParser {
  bool inAlias;
  bool inDirname;
  bool inFolderHTML;
  bool inInclude;
  bool inSort;
  
  //The comment after we are done stripping out all the XML
  string finalComment;
  string sortOrder;
  
  reference & r;
  
public:
  FolderCommentParser(reference & ref) : r(ref) {
    inAlias = false;
    inDirname = false;
    inFolderHTML = false;
    inInclude = false;
    inSort = false;
    finalComment = "";
    sortOrder = "";
  };

  void startTag(string &tagName, map<string,string> & attributes);
  void endTag(string &tagName);
  void cdata(string &content);
  void parse(string & data);
};

#endif // XMLPARSER_H
