/* Bluefish HTML Editor
 * pixmaps.c - There be pixmaps here cap'n
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 * Most Pixmaps (C) 1998 Hylke van der Schaaf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include "../pixmaps/new.xpm"
#include "../pixmaps/close.xpm"
#include "../pixmaps/copy.xpm"
#include "../pixmaps/cut.xpm"
#include "../pixmaps/help.xpm"
#include "../pixmaps/yes.xpm"
#include "../pixmaps/no.xpm"
#include "../pixmaps/ok.xpm"
#include "../pixmaps/cancel.xpm"
#include "../pixmaps/open.xpm"
#include "../pixmaps/open_small.xpm"
#include "../pixmaps/paste.xpm"
#include "../pixmaps/preferences.xpm"
#include "../pixmaps/print.xpm"
#include "../pixmaps/redo.xpm"
#include "../pixmaps/save.xpm"
#include "../pixmaps/save_as.xpm"
#include "../pixmaps/search-replace.xpm"
#include "../pixmaps/search.xpm"
#include "../pixmaps/spellcheck.xpm"
#include "../pixmaps/undo.xpm"
#include "../pixmaps/quick_start.xpm"
#include "../pixmaps/body.xpm"
#include "../pixmaps/bold.xpm"
#include "../pixmaps/italic.xpm"
#include "../pixmaps/underline.xpm"
#include "../pixmaps/strikeout.xpm"
#include "../pixmaps/paragraph.xpm"
#include "../pixmaps/break.xpm"
#include "../pixmaps/nbsp.xpm"
#include "../pixmaps/anchor.xpm"
#include "../pixmaps/image.xpm"
#include "../pixmaps/thumbnail.xpm"
#include "../pixmaps/hrule.xpm"
#include "../pixmaps/center.xpm"
#include "../pixmaps/right.xpm"
#include "../pixmaps/comment.xpm"
#include "../pixmaps/email.xpm"
#include "../pixmaps/font.xpm"
#include "../pixmaps/font_base.xpm"
#include "../pixmaps/fontp1.xpm"
#include "../pixmaps/fontm1.xpm"
#include "../pixmaps/fontpre.xpm"
#include "../pixmaps/fontsub.xpm"
#include "../pixmaps/fontsuper.xpm"
#include "../pixmaps/headings.xpm"
#include "../pixmaps/fonth1.xpm"
#include "../pixmaps/fonth2.xpm"
#include "../pixmaps/fonth3.xpm"
#include "../pixmaps/fonth4.xpm"
#include "../pixmaps/fonth5.xpm"
#include "../pixmaps/fonth6.xpm"
#include "../pixmaps/tablewhiz.xpm"
#include "../pixmaps/table.xpm"
#include "../pixmaps/table-tr.xpm"
#include "../pixmaps/table-th.xpm"
#include "../pixmaps/table-td.xpm"
#include "../pixmaps/table2.xpm"
#include "../pixmaps/table-tr2.xpm"
#include "../pixmaps/table-th2.xpm"
#include "../pixmaps/table-td2.xpm"
#include "../pixmaps/table-capt.xpm"
#include "../pixmaps/framewhiz.xpm"
#include "../pixmaps/frameset.xpm"
#include "../pixmaps/frame.xpm"
#include "../pixmaps/frameset2.xpm"
#include "../pixmaps/frame2.xpm"
#include "../pixmaps/frame_no.xpm"
#include "../pixmaps/frame_base.xpm"
#include "../pixmaps/form.xpm"
#include "../pixmaps/form_submit.xpm"
#include "../pixmaps/form_reset.xpm"
#include "../pixmaps/form_text.xpm"
#include "../pixmaps/form_hidden.xpm"
#include "../pixmaps/form_textarea.xpm"
#include "../pixmaps/form_radio.xpm"
#include "../pixmaps/form_check.xpm"
#include "../pixmaps/form_select.xpm"
#include "../pixmaps/form_option.xpm"
#include "../pixmaps/list.xpm"
#include "../pixmaps/list_ul.xpm"
#include "../pixmaps/list_ol.xpm"
#include "../pixmaps/list_li.xpm"
#include "../pixmaps/list_dl.xpm"
#include "../pixmaps/list_dt.xpm"
#include "../pixmaps/list_dd.xpm"
#include "../pixmaps/list_menu.xpm"
#include "../pixmaps/image_map.xpm"
#include "../pixmaps/meta.xpm"
#include "../pixmaps/embed.xpm"
#include "../pixmaps/netscape.xpm"
#include "../pixmaps/color_select.xpm"
#include "../pixmaps/color_select_small.xpm"
#include "../pixmaps/time.xpm"
#include "../pixmaps/nothing.xpm"
#include "../pixmaps/php3.xpm"
#include "../pixmaps/ssi.xpm"
#include "../pixmaps/rxml.xpm"
#include "../pixmaps/breakall.xpm"
/* #include "../pixmaps/dtd.xpm"
#include "../pixmaps/head.xpm" */
#include "../pixmaps/cssnewstyle.xpm"
#include "../pixmaps/cssspan.xpm"
#include "../pixmaps/cssdiv.xpm"
#include "../pixmaps/cssclass.xpm"
#include "../pixmaps/cssstyle.xpm"
#include "../pixmaps/css_small.xpm"
#include "../pixmaps/linkjscript.xpm"
#include "../pixmaps/jscript.xpm"
#include "../pixmaps/linkstylesheet.xpm"
#include "../pixmaps/bluefish_small.xpm"
#include "../pixmaps/wml_a.xpm"
#include "../pixmaps/wml_access.xpm"
#include "../pixmaps/wml_bold.xpm"
#include "../pixmaps/wml_break.xpm"
#include "../pixmaps/wml_card.xpm"
#include "../pixmaps/wml_do.xpm"
#include "../pixmaps/wml_go.xpm"
#include "../pixmaps/wml_italic.xpm"
#include "../pixmaps/wml_nbsp.xpm"
#include "../pixmaps/wml_paragraph.xpm"
#include "../pixmaps/wml_standard_document.xpm"
#include "../pixmaps/wml_timer.xpm"
#include "../pixmaps/wml_postfield.xpm"
#include "../pixmaps/wml_var.xpm"
#include "../pixmaps/wml_prev.xpm"
#include "../pixmaps/wml_refresh.xpm"
#include "../pixmaps/wml_noop.xpm"
#include "../pixmaps/abbr.xpm"
#include "../pixmaps/acronym.xpm"
#include "../pixmaps/cite.xpm"
#include "../pixmaps/code.xpm"
#include "../pixmaps/dfn.xpm"
#include "../pixmaps/kbd.xpm"
#include "../pixmaps/samp.xpm"
#include "../pixmaps/var.xpm"
#include "../pixmaps/javascript_mouseover.xpm"
#include "../pixmaps/javascript_netscape.xpm"
#include "../pixmaps/javascript_preload.xpm"


GtkWidget *new_pixmap(int type, GdkWindow * window, GdkColor * background)
{
	GtkWidget *wpixmap;
	GdkPixmap *pixm = NULL;
	GdkBitmap *mask = NULL;
	/* editor toolbar stuff */
	switch (type) {
	case 000:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, new_xpm);
		break;
	case 001:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_xpm);
		break;
	case 002:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, save_xpm);
		break;
	case 003:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, save_as_xpm);
		break;
	case 004:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, close_xpm);
		break;
	case 005:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, copy_xpm);
		break;
	case 006:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cut_xpm);
		break;
	case 007:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, paste_xpm);
		break;
	case 010:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, search_xpm);
		break;
	case 011:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, search_replace_xpm);
		break;
	case 012:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, undo_xpm);
		break;
	case 013:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, redo_xpm);
		break;
	case 014:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, preferences_xpm);
		break;
	case 015:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, print_xpm);
		break;
	case 016:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, spellcheck_xpm);
		break;
		/* HTML toolbar stuff */
	case 100:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, quick_start_xpm);
		break;
	case 101:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, body_xpm);
		break;
	case 102:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, bold_xpm);
		break;
	case 103:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, italic_xpm);
		break;
	case 104:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, underline_xpm);
		break;
	case 105:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, strikeout_xpm);
		break;
	case 106:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, paragraph_xpm);
		break;
	case 107:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, break_xpm);
		break;
	case 108:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, breakall_xpm);
		break;
	case 110:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, nbsp_xpm);
		break;
	case 111:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, anchor_xpm);
		break;
	case 112:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, hrule_xpm);
		break;
	case 113:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, image_xpm);
		break;
	case 114:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, center_xpm);
		break;
	case 115:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, right_xpm);
		break;
	case 116:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, comment_xpm);
		break;
	case 117:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, email_xpm);
		break;
	case 118:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, font_xpm);
		break;
	case 119:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, font_base_xpm);
		break;
	case 120:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontp1_xpm);
		break;
	case 121:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontm1_xpm);
		break;
	case 122:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontpre_xpm);
		break;
	case 123:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontsub_xpm);
		break;
	case 124:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontsuper_xpm);
		break;
	case 125:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, thumbnail_xpm);
		break;
	case 127:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth1_xpm);
		break;
	case 128:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth2_xpm);
		break;
	case 129:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth3_xpm);
		break;
	case 130:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth4_xpm);
		break;
	case 131:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth5_xpm);
		break;
	case 132:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth6_xpm);
		break;
	case 133:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, tablewhiz_xpm);
		break;
	case 134:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_xpm);
		break;
	case 135:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_tr_xpm);
		break;
	case 136:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_th_xpm);
		break;
	case 137:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_td_xpm);
		break;
	case 138:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table2_xpm);
		break;
	case 139:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_tr2_xpm);
		break;
	case 140:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_th2_xpm);
		break;
	case 141:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_td2_xpm);
		break;
	case 142:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_capt_xpm);
		break;
	case 143:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, framewhiz_xpm);
		break;
	case 144:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frameset_xpm);
		break;
	case 145:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_xpm);
		break;
	case 146:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frameset2_xpm);
		break;
	case 147:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame2_xpm);
		break;
	case 148:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_no_xpm);
		break;
	case 149:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_base_xpm);
		break;
	case 150:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_xpm);
		break;
	case 151:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_submit_xpm);
		break;
	case 152:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_reset_xpm);
		break;
	case 153:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_text_xpm);
		break;
	case 154:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_hidden_xpm);
		break;
	case 155:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_textarea_xpm);
		break;
	case 156:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_radio_xpm);
		break;
	case 157:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_check_xpm);
		break;
	case 158:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_select_xpm);
		break;

	case 417:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_option_xpm);
		break;
	case 159:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_xpm);
		break;
	case 160:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_ul_xpm);
		break;
	case 161:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_ol_xpm);
		break;
	case 162:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_li_xpm);
		break;
	case 163:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dl_xpm);
		break;
	case 164:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dt_xpm);
		break;
	case 165:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dd_xpm);
		break;
	case 166:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_menu_xpm);
		break;
	case 167:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, image_map_xpm);
		break;
	case 168:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, meta_xpm);
		break;
	case 169:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, embed_xpm);
		break;
	case 170:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, netscape_xpm);
		break;
	case 171:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, color_select_xpm);
		break;
	case 172:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, time_xpm);
		break;
	case 173:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, php3_xpm);
		break;
	case 174:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, ssi_xpm);
		break;
	case 175:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, rxml_xpm);
		break;
	case 176:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, color_select_small_xpm);
		break;
	case 177:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_small_xpm);
		break;

	case 180:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssnewstyle_xpm);
		break;
	case 181:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssspan_xpm);
		break;
	case 182:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssdiv_xpm);
		break;
	case 183:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssclass_xpm);
		break;
	case 184:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssstyle_xpm);
		break;
/*
	case 185:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, dtd_xpm);
		break;
	case 186:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, head_xpm);
		break;
	*/
	case 187:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, linkjscript_xpm);
		break;
	case 188:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, jscript_xpm);
		break;
	case 189:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, linkstylesheet_xpm);
		break;
	case 190:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, bluefish_small_xpm);
		break;
	case 191:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, headings_xpm);
		break;
	case 192:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, css_small_xpm);
		break;

		/* everything else */
	case 200:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, help_xpm);
		break;
	case 201:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, yes_xpm);
		break;
	case 202:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, no_xpm);
		break;
	case 203:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, ok_xpm);
		break;
	case 204:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cancel_xpm);
		break;

	case 300:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, nothing_xpm);
		break;


		/* wml pixmaps */
	case 400:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_standard_document_xpm);
		break;
	case 401:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_bold_xpm);
		break;
	case 402:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_card_xpm);
		break;
	case 403:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_break_xpm);
		break;
	case 404:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_italic_xpm);
		break;
	case 405:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_nbsp_xpm);
		break;
	case 406:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_paragraph_xpm);
		break;
	case 407:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_timer_xpm);
		break;
	case 408:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_postfield_xpm);
		break;
	case 409:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_var_xpm);
		break;
	case 410:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_go_xpm);
		break;
	case 411:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_prev_xpm);
		break;
	case 412:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_refresh_xpm);
		break;
	case 413:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_noop_xpm);
		break;
	case 414:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_do_xpm);
		break;
	case 415:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_a_xpm);
		break;
	case 416:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, wml_access_xpm);
		break;
	/* html formatting by context pixmaps */
	case 418: /* acronym */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, acronym_xpm);
		break;
	case 419: /* cite */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cite_xpm);
		break;
	case 420: /* code */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, code_xpm);
		break;
	case 421: /* dfn */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, dfn_xpm);
		break;
	case 422: /* kbd */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, kbd_xpm);
		break;
	case 423: /* samp */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, samp_xpm);
		break;
	case 424: /* var */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, var_xpm);
		break;
	case 425: /* abbr */
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, abbr_xpm);
		break;		
		/* javascript pixmaps */
	case 500:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, javascript_mouseover_xpm);
		break;
	case 501:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, javascript_netscape_xpm);
		break;
	case 502:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, javascript_preload_xpm);
		break;

	}

	wpixmap = gtk_pixmap_new(pixm, mask);
	gdk_pixmap_unref(pixm);
	gdk_bitmap_unref(mask);
	return wpixmap;
}
