//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <gtkmm.h>
#include <glibmm.h>
#include <glibmm/i18n.h>
#include <glib/gstdio.h>

#include <cstdio>
#include <cstdlib>
#include <cstring>

#include <unistd.h>
#include <sys/stat.h>

#include "util.hh"
#include "uri++.hh"
#include "util_file.hh"
#include "network.hh"
#include "debug.hh"

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#include <boost/format.hpp>
#include <boost/algorithm/string.hpp>

#include "x_library.hh"

#include "neon++/request.hh"

#include "main.hh"
#include "paths.hh"
#include "mbxml.hh"
#include "amazon.hh"
#include "xml.hh"

namespace
{
  const char* amazon_hosts[] =
  {
    "images.amazon.com",  
    "images-eu.amazon.com",
    "images.amazon.co.uk", 
    "images.amazon.jp",   
    "ec1.images-amazon.com",
  };

  static boost::format famazon ("http://%s/images/P/%s.01.MZZZZZZZ.jpg");
}

namespace Bmp
{
  namespace Amazon
  {
    void 
    cache (Glib::ustring const& asin)
    {
      using namespace Gdk;
      using namespace Glib;
      using namespace Bmp;
      using namespace std;

      string basename = (boost::format ("%s.png") % asin).str ();
      string thumb_path = Glib::build_filename (BMP_PATH_COVER_THUMB_DIR, basename);
      if (Glib::file_test (thumb_path, Glib::FILE_TEST_EXISTS)) return;

      for (unsigned int n = 0; n < G_N_ELEMENTS(amazon_hosts); ++n)
        {
          if (!Network::check_host (amazon_hosts[n])) continue;

          URI u ((famazon % amazon_hosts[n] % asin).str(), true);
          Neon::Request request (u.hostname, u.path);  
          RefPtr<Gdk::PixbufLoader> loader;
          try {
              request.dispatch ();
              const ne_status * status = request.get_status();
              if (status->code != 404)
                {
                  loader = PixbufLoader::create ();
                  loader->write (reinterpret_cast<const guint8*>(request.get_data()), request.get_data_size());
                  request.clear ();
                  loader->close ();
                  loader->get_pixbuf()->save (thumb_path, "png");
                  loader.clear();
                  return;
                }
            }
          catch (Gdk::PixbufError & cxe)
            {
              loader.clear ();
              return;
            }
          catch (Neon::Request::Exception & cxe)
            {
            }
        }
      throw NoCoverError("No cover on Amazon found!");
    }

    void 
    fetch (Glib::ustring const& asin, Glib::RefPtr<Gdk::Pixbuf>& cover, bool only_cached)
    {
      using namespace Gdk;
      using namespace Glib;
      using namespace Bmp;
      using namespace std;

      string basename = (boost::format ("%s.png") % asin).str ();
      string thumb_path = Glib::build_filename (BMP_PATH_COVER_THUMB_DIR, basename);
      if (Glib::file_test (thumb_path, Glib::FILE_TEST_EXISTS))
        {
          cover = Gdk::Pixbuf::create_from_file (thumb_path); 
          return;
        }

      if (only_cached)
          throw NoCoverError("No cached cover present");

      for (unsigned int n = 0; n < G_N_ELEMENTS(amazon_hosts); ++n)
        {
          if (!Network::check_host (amazon_hosts[n])) continue;

          URI u ((famazon % amazon_hosts[n] % asin).str(), true);
          Neon::Request request (u.hostname, u.path);  
          RefPtr<Gdk::PixbufLoader> loader;
          try {
              request.dispatch ();
              const ne_status * status = request.get_status();
              if (status->code != 404)
                {
                  loader = PixbufLoader::create ();
                  loader->write (reinterpret_cast<const guint8*>(request.get_data()), request.get_data_size());
                  request.clear ();
                  loader->close ();
                  loader->get_pixbuf()->save (thumb_path, "png");
                  cover = loader->get_pixbuf()->scale_simple ( 128, 128, INTERP_BILINEAR );
                  loader.clear();
                  return;
                }
            }
          catch (Gdk::PixbufError & cxe)
            {
              loader.clear ();
              return;
            }
          catch (Neon::Request::Exception & cxe)
            {
            }
        }
      throw NoCoverError("No cover on Amazon found!");
    }
  }
}
