/*
 * Copyright (C) 1998  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_PACKET_TYPES
#define INCLUDED_PACKET_TYPES

#ifdef JUST_NEED_TYPES
#include "field_sizes.h"
#include "init_protocol.h"
#include "bnet_protocol.h"
#include "file_protocol.h"
#include "bot_protocol.h"
#include "bits_protocol.h"
#include "udp_protocol.h"
#else
#define JUST_NEED_TYPES
#include "field_sizes.h"
#include "init_protocol.h"
#include "bnet_protocol.h"
#include "file_protocol.h"
#include "bot_protocol.h"
#include "bits_protocol.h"
#include "udp_protocol.h"
#undef JUST_NEED_TYPES
#endif

typedef enum
{
    packet_class_none,
    packet_class_normal,
    packet_class_file,
    packet_class_raw
} t_packet_class;


typedef enum
{
    packet_dir_from_client,
    packet_dir_from_server
} t_packet_dir;


/* These aren't really packets so much as records in a TCP stream. They are variable-
 * length structures which make up the Battle.net protocol. It is just easier to call
 * them "packets".
 */
typedef struct
{
    unsigned int   ref;   /* reference count */
    t_packet_class class;
    unsigned int   flags; /* user-defined flags (used to mark UDP in bnproxy) */
    unsigned int   len;   /* raw packets have no header, so we use this */
    
    /* next part looks just like it would on the network (no padding, byte for byte) */
    union
    {
        char                       data[MAX_PACKET_SIZE];
        t_normal_generic           normal;
        t_file_generic             file;
        
        t_server_authreply         server_authreply;
        t_server_authreq           server_authreq;
        t_client_authreq           client_authreq;
        t_client_cdkey             client_cdkey;
        t_server_cdkeyreply        server_cdkeyreply;
        t_client_statsreq          client_statsreq;
        t_server_statsreply        server_statsreply;
        t_client_loginreq          client_loginreq;
        t_server_loginreply        server_loginreply;
        t_client_progident         client_progident;
        t_client_progident2        client_progident2;
        t_client_joinchannel       client_joinchannel;
        t_server_channellist       server_channellist;
        t_server_serverlist        server_serverlist;
        t_server_message           server_message;
        t_client_message           client_message;
        t_client_gamelistreq       client_gamelistreq;
        t_server_gamelistreply     server_gamelistreply;
        t_client_unknown_14        client_unknown_14;
        t_client_unknown_1b        client_unknown_1b;
        t_client_startgame1        client_startgame1;
        t_server_startgame1_ack    server_startgame1_ack;
        t_client_startgame3        client_startgame3;
        t_server_startgame3_ack    server_startgame3_ack;
        t_client_startgame4        client_startgame4;
        t_server_startgame4_ack    server_startgame4_ack;
        t_client_leavechannel      client_leavechannel;
        t_client_closegame         client_closegame;
        t_client_mapauthreq        client_mapauthreq;
        t_server_mapauthreply      server_mapauthreply;
        t_client_ladderreq         client_ladderreq;
        t_server_ladderreply       server_ladderreply;
	t_client_laddersearchreq   client_laddersearchreq;
	t_server_laddersearchreply server_laddersearchreply;
        t_client_adreq             client_adreq;
        t_server_adreply           server_adreply;
        t_client_adack             client_adack;
	t_client_adclick           client_adclick;
        t_client_game_report       client_gamerep;
        t_server_sessionkey1       server_sessionkey1;
        t_server_sessionkey2       server_sessionkey2;
        t_client_createacctreq     client_createacctreq;
        t_server_createacctreply   server_createacctreply;
        t_client_changepassreq     client_changepassreq;
        t_server_changepassack     server_changepassack;
        t_client_iconreq           client_iconreq;
        t_server_iconreply         server_iconreply;
        t_client_tosreq            client_tosreq;
        t_server_tosreply          server_tosreply;
        t_client_statsupdate       client_statsupdate;
        t_client_countryinfo       client_countryinfo;
        t_client_unknown_2b        client_unknown_2b;
        t_client_compinfo1         client_compinfo1;
        t_client_compinfo2         client_compinfo2;
        t_server_compreply         server_compreply;
        t_server_echoreq           server_echoreq;
        t_client_echoreply         client_echoreply;
        t_client_playerinforeq     client_playerinforeq;
        t_server_playerinforeply   server_playerinforeply;
	t_client_file_req          client_file_req;
	t_server_file_reply        server_file_reply;
	t_client_pingreq           client_pingreq;
	t_server_pingreply         server_pingreply;
        t_client_cdkey2            client_cdkey2;
        t_server_cdkeyreply2       server_cdkeyreply2;
    } u;
} t_packet;

#endif


#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_PACKET_PROTOS
#define INCLUDED_PACKET_PROTOS

extern t_packet * packet_create(t_packet_class class);
extern void packet_destroy(t_packet const * packet);
extern t_packet * packet_add_ref(t_packet * packet);
extern void packet_del_ref(t_packet * packet);
extern t_packet_class packet_get_class(t_packet const * packet);
extern char const * packet_get_class_str(t_packet const * packet);
extern unsigned short packet_get_type(t_packet const * packet);
extern char const * packet_get_type_str(t_packet const * packet, t_packet_dir dir);
extern int packet_set_type(t_packet * packet, unsigned short type);
extern unsigned short packet_get_size(t_packet const * packet);
extern int packet_set_size(t_packet * packet, unsigned short size);
extern unsigned int packet_get_flags(t_packet * packet);
extern int packet_set_flags(t_packet * packet, unsigned int flags);
extern int packet_append_string(t_packet * packet, char const * str);
extern int packet_append_data(t_packet * packet, void const * data, unsigned int len);
extern void const * packet_get_raw_data_const(t_packet const * packet, unsigned int offset);
extern void * packet_get_raw_data(t_packet * packet, unsigned int offset);
extern void * packet_get_raw_data_build(t_packet * packet, unsigned int offset);
extern char const * packet_get_str_const(t_packet const * packet, unsigned int offset, unsigned int maxlen);
extern void const * packet_get_data_const(t_packet const * packet, unsigned int offset, unsigned int len);

#endif
#endif
