#! /bin/bash
# Check to see if all the needed packages are in the archive.
# Enrique Zanardi, 1998
# This is free software under the GNU General Public License.

. ./common.sh

# don't exit on errors for this script
set +e

if [ $# != 1 ]; then
echo "Usage: $0 archive" 1>&2
        cat 1>&2 << EOF

        archive: the directory containing the Debian binary packages.
EOF
        exit -1
fi

# Set this to the location of the package archive.
archive=$1

rootscripts=`pwd`/scripts/rootdisk
basescripts=`pwd`/scripts/basedisks
extract_subarch_list=`ls $rootscripts/EXTRACT_LIST_${arch}_* 2> /dev/null` || true
rootfiles="$rootscripts/EXTRACT_LIST_all \
        $rootscripts/EXTRACT_LIST_${arch} \
	$extract_subarch_list" \
basefiles="$basescripts/PACKAGES_all \
        $basescripts/PACKAGES_${arch} \
        $basescripts/PARTIAL_PACKAGES_all \
        $basescripts/PARTIAL_PACKAGES_${arch}"

exit=false

for i in $rootfiles $basefiles; do
        if [ ! -f $i ]; then
                echo "Can't open $i"
                exit=true
        fi
done
if $exit; then
        exit -1
fi

exit=false

# Check to see if all the needed packages are in the archive.
echo "checking packages needed in the root disk"
PACKAGE_PATHS=`make_paths \`cat $rootfiles\``
if [ $? -ne 0 ]; then
        exit=true;
fi
echo "checking packages needed in the base system"
PACKAGE_PATHS=`make_paths \`cat $basefiles\``
if [ $? -ne 0 ]; then
        exit=true;
fi

if $exit; then
	exit -1
fi
