#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"
#include <sys/mount.h>
#ifdef _TESTING_
  #include <stdio.h>
#endif

int reboot_system (void) {
  int write_common_network (void);
  sync();
  if (! bootargs.isquiet ) {
    if (strcmp(InstallationRootDevice, "/dev/fd0")) {
      if (! bootargs.isquiet && ! yesNoBox(_("If you are ready to reboot the system, you should have the boot floppy (if you created one) in the first floppy drive, or no floppy in the first floppy drive if you want to boot directly from the hard disk, or the Debian Rescue floppy if you want to reboot the installation system.\nPlease take care of that before you answer \"Yes\" to the following question.\n\nReboot the system?"), _("Reboot the system?")) )
	return 1;
    } else {
      if (! bootargs.isquiet && ! yesNoBox(_("Since you've booted from the first floppy drive without using the RAM disk, please keep the Installation Root Disk in the drive until the system reboots. Then remove it, and press the <RESET> button on your system.\n\nReboot the system?"), _("Reboot the system?")) )
	return 1;
    }
  }

  if(!is_network_configured())
    write_common_network();
  execlog("cp /var/log/messages /target/var/log/installer.log", LOG_INFO);

  sync();
  boxSuspend();
#ifdef _TESTING_
  printf("Fake rebooting... (waiting 15 secs)\n");
#else
  system("reboot");
#endif
  sleep(15);
  boxResume();
  return 1;
}

/* This is the mondo cool "no-restart-just-continue-the-setup-in-the-new-system"
 * patch.
 */
int chroot_start (void) {
    int fd;
    struct fdisk_partition *mp;
    
#ifndef _TESTING_
    if (! initchroot_cap())
	goto bailout;
#endif

    if (! bootargs.isquiet && ! yesNoBox(_("The system configuration will continue after the system starts in the newly installed setup.\n\nNote, this bypasses a normal reboot, which means boot loader problems may not be apparent until you actually do reboot the system.\n\nStart the new system?"), _("Start the new system?")))
	return 1;
		
#ifndef _TESTING_
    /* Ok, first we must let init know where the new root will be */
    mp = fdisk_find_partition_by_mntpoint("/target");
    if ((fd = open("/proc/sys/kernel/init-chroot", O_WRONLY|O_TRUNC)) == -1)
	goto bailout;
    if (write(fd, "/target", 7) < 1)
	goto bailout;
    close(fd);

    /* Now we commit, and umount all but the new and current root */
    sync();
    boxSuspend();

    execlog("swapoff -a", LOG_INFO);
    
    for (mp = mounted_partitions; mp != NULL; mp = mp->next) {
	if (strcmp(mp->mount_point, "/") && strcmp(mp->mount_point, "/target"))
	    umount(mp->mount_point);
	else {
	    snprintf(prtbuf, sizeof(prtbuf), "mount -o remount,ro %s %s", mp->name,
		    mp->mount_point);
	    execlog(prtbuf, LOG_INFO);
	}
    }

    /* make sure we mount "/" read-only */
    execlog("mount -o remount,ro /dev/root /", LOG_INFO);

    /* Now we send the signal to init and wait... */
    fprintf(stderr, _("Sending signal to `init' to initiate system start...\n"));
    kill(1, SIGHUP);
    sleep(15);
    
bailout:
    boxResume();
#endif /* !_TESTING_ */
    wideMessageBox(_("\nCould not setup init-chroot for starting the new system. Try simply rebooting instead (this is not a bug).\n"),
	    _("System start failed"));
    return 1;
}

#ifdef _TESTING_
/* To test, compile using: make reboot_system_test */
void main(void){
	LOAD_TRMFILE("test.trm");
	get_kver();
	boxInit();

	InstallationRootDevice=strdup("/dev/sdc");
	reboot_system();

	boxFinished();
}
#endif

