 
#include <stdio.h>
#include <assert.h>
#include <sys/sysmacros.h>
#include "dbootstrap.h"
#include "lang.h"
#include <linux/termios.h>
#include <linux/serial.h>
#include <syslog.h> 
#include "util.h"

static int failedBaseInstall = 0;

int true (void) {
	return 0;
}

#ifdef _TESTING_

int next_action(void);
int alternate_action(void);
int alternate1_action(void);
int previous_action(void);
int previous1_action(void);
int partition_disk(void);
int init_swap(void);
int activate_swap(void);
int no_swap(void);
int init_linux(void);
int mount_any(void);
int unmount_any(void);
int extract_kernel_and_modules(void); 
int debootstrap_extract_base(void);
int configure_drivers(void);
int configure_network(void);
int make_bootable(void);
int make_boot_floppy(void);
int reboot_system(void);
int halt_system(void);
int chroot_start(void);
int view_partitions(void);
int interactive_shell(void);
int configure_pcmcia(void);
int do_eject(void);
int load_modules_after_boot(void);
int load_modules_after_boot_ac(void);
int edit_append_line();
int add_modules_from_floppy(void);
int attach_disk(void);

#else //!_TESTING_

static char*
find_root (void)
{
	char                   *root_device;
	char                   *target_device;
	struct fdisk_partition *p;

	if ((root_device = block_device ( "/" )) == NULL) {
		return NULL;
	}
	if ((target_device = block_device ("/target" )) == NULL) {
		/* Perhaps it's a loop-mounted fs, or NFS */
		if ((p = fdisk_find_partition_by_mntpoint ("/target")) == NULL) {
			free (root_device);
			return NULL;
		}
		target_device = strdup (p->name);
	}
	if (strcmp (root_device,target_device)){
		return target_device;
	}
	root_device = strdup("");
	return root_device;
}

static int
require_root (void)
{
	if (!Root) {
		problemBox (_("The requested operation can't be performed until the root filesystem is mounted. \nBefore you begin installation, you must first partition your disk, and then initialize and mount your root filesystem, and initialize a swap partition. Please use the main menu to complete any of those steps that you have not done, and then use the main menu to return to this step."),
			    _("No root filesystem mounted"));
		return 1;
	}
	return 0;
}


#ifdef DO_EJECT
void
eject_floppy (const char *device)
{
	sprintf (prtbuf, "eject %s", device);
	execlog (prtbuf, LOG_INFO);
}
#endif
#endif //!_TESTING_

int main_menu_extract_base ()
{
	return failedBaseInstall = debootstrap_extract_base ();
}

int
main_menu (void)
{
#ifndef _TESTING_
	char *found_root = NULL;
#endif
	int offerred_keyboard = 0;
	struct stat statbuf;
	int (*next_action) (void);
	int (*alternate_action) (void);
	int (*alternate1_action) (void);
	int (*previous_action) (void);
	int (*previous1_action) (void);
	char *bufT, *bufN, *bufA, *bufA1, *bufP, *bufP1;
#define OPT_Next		1001
#define OPT_Alternate		1002
#define OPT_Alternate1		1003
#define OPT_Previous		1004
#define OPT_Previous1		1005
#define OPT_CONFIGURE_KEY	1006
#define OPT_PARTITION_DISK	1007
#define OPT_INITIALIZE_SWAP	1008
#define OPT_ACTIVATE_SWAP	1009
#define OPT_DO_WITHOUT_SWAP	1010
#define OPT_INITIALIZE_LINUX	1011
#define OPT_MOUNT_LINUX		1012
#define OPT_UMOUNT_LINUX	1013
#define OPT_INSTALL_OS		1014
#define OPT_INSTALL_BASE	1015
#define OPT_CONFIGURE_MODULES	1016
#define OPT_CONFIGURE_NET	1018
#define OPT_DISK_BOOT		1019
#define OPT_FLOPPY_BOOT		1020
#define OPT_REBOOT		1021
#define OPT_VIEW_PARTITIONS	1022
#define OPT_EXECUTE_SHELL	1023
#define OPT_CONFIGURE_PCMCIA	1024
#define OPT_EJECT_FLOPPY	1025
#define OPT_RESTART_DBOOTSTRAP	1026
#define OPT_START_NEW_SYSTEM	1027
#define OPT_CONFIGURE_HOSTNAME	1028
#define OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT 1029
#define OPT_KERNEL_APPEND	1030
#define OPT_PROBLEM_REPORT	1031
#define OPT_FOREIGN_MODULES	1032
#define OPT_ATTACH_DISK   	1033
#define NITEMS	31
	int data, ilist[NITEMS], items, i, rs;
	struct d_choices choices[NITEMS];
	struct { char *string; int key; } entries[] = {
#if !(#cpu(s390))
		{_("Configure the Keyboard"),				OPT_CONFIGURE_KEY},
#endif
#if (#cpu(s390))
		{_("Attach a Disk"),					OPT_ATTACH_DISK},
#endif
/* since this process uses lilo, we only use it with i386 */
#if (#cpu(i386))
		/* TRANS: keep it short */
		{_("Preload Modules from a Floppy"),	OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT},
#endif
		{_("Partition a Hard Disk"),				OPT_PARTITION_DISK},
		{_("Initialize and Activate a Swap Partition"),		OPT_INITIALIZE_SWAP},
		{_("Activate a Previously-Initialized Swap Partition"),	OPT_ACTIVATE_SWAP},
		{_("Do Without a Swap Partition"),			OPT_DO_WITHOUT_SWAP},
		{_("Initialize a Linux Partition"),			OPT_INITIALIZE_LINUX},
		{_("Mount a Previously-Initialized Partition"),		OPT_MOUNT_LINUX},
		{_("Unmount a Partition"),				OPT_UMOUNT_LINUX},
		{_("Install Kernel and Driver Modules"),		OPT_INSTALL_OS},
		{_("Configure Device Driver Modules"),			OPT_CONFIGURE_MODULES},
#ifdef PCMCIA
		{_("Configure PCMCIA Support"),				OPT_CONFIGURE_PCMCIA},
#endif
#if !(#cpu(s390))
		{_("Install Foreign Modules"),				OPT_FOREIGN_MODULES},
#endif
		{_("Configure the Hostname"),				OPT_CONFIGURE_HOSTNAME},
		{_("Configure the Network"),				OPT_CONFIGURE_NET},
		{_("Install the Base System"),				OPT_INSTALL_BASE},
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc) || #cpu(powerpc))
		{_("Edit Kernel Boot Parameters"),			OPT_KERNEL_APPEND},
#endif
		{_("Make System Bootable"),				OPT_DISK_BOOT},
#if (#cpu(alpha) || #cpu(i386) || #cpu(sparc)) 
		{_("Make a Boot Floppy"),				OPT_FLOPPY_BOOT},
#endif
#if 0 /* not working yet */
		{_("Start New System"),					OPT_START_NEW_SYSTEM},
#endif
		{_("Reboot the System"),				OPT_REBOOT},
		{_("View the Partition Table"),				OPT_VIEW_PARTITIONS},
		{_("Execute a Shell"),					OPT_EXECUTE_SHELL},
		{_("Report a Problem"),					OPT_PROBLEM_REPORT},
#ifdef DO_EJECT
		{_("Eject Floppy Disks"),				OPT_EJECT_FLOPPY},
#endif
		{_("Restart Installation System"),			OPT_RESTART_DBOOTSTRAP},
		{NULL,0}
	};

#if (#cpu(powerpc))
	struct { char *string; int key; } entries_apus[] = {
		{_("Configure the Keyboard"),				OPT_CONFIGURE_KEY},
		{_("Partition a Hard Disk"),				OPT_PARTITION_DISK},
		{_("Initialize and Activate a Swap Partition"),		OPT_INITIALIZE_SWAP},
		{_("Activate a Previously-Initialized Swap Partition"),	OPT_ACTIVATE_SWAP},
		{_("Do Without a Swap Partition"),			OPT_DO_WITHOUT_SWAP},
		{_("Initialize a Linux Partition"),			OPT_INITIALIZE_LINUX},
		{_("Mount a Previously-Initialized Partition"),		OPT_MOUNT_LINUX},
		{_("Unmount a Partition"),				OPT_UMOUNT_LINUX},
		{_("Install Operating System Modules"),			OPT_INSTALL_OS},
		{_("Configure Device Driver Modules"),			OPT_CONFIGURE_MODULES},
		{_("Install Foreign Modules"),				OPT_FOREIGN_MODULES},
		{_("Configure the Hostname"),				OPT_CONFIGURE_HOSTNAME},
		{_("Configure the Network"),				OPT_CONFIGURE_NET},
		{_("Install the Base System"),				OPT_INSTALL_BASE},
		{_("Reboot the System"),				OPT_REBOOT},
		{_("View the Partition Table"),				OPT_VIEW_PARTITIONS},
		{_("Execute a Shell"),					OPT_EXECUTE_SHELL},
		{_("Restart Installation System"),			OPT_RESTART_DBOOTSTRAP},
		{_("Report a Problem"),					OPT_PROBLEM_REPORT},
		{NULL,0}
	};
#endif

	for (;;) {
		pleaseWaitBox (
			_("The installation program is determining the current state "
			  "of your system and the next installation step that should "
			  "be performed."));
		memset (choices, 0, NITEMS * sizeof (struct d_choices));

#ifndef _TESTING_
	if (Root) {
	    found_root = strdup (Root->name);
	}

	fdisk_reread();
#if !(#cpu(s390))
	if (fdisk_disks == NULL) {
	    /* no swap on NFS for diskless workstation */
	    noSwap = 1;
	    /* no boot loader on local disk */
	    notInstalledLILO = 0;
	}
#endif

	if (found_root) {
	    Root = fdisk_find_partition_by_name (found_root);
	    free (found_root);
	    found_root = NULL;
	    Boot = fdisk_find_partition_by_mntpoint ("/target/boot");
	    if (Boot == NULL) Boot = Root;
	}

	if (! (found_root = find_root())){
	    if (Root) {
		sprintf (prtbuf, _("I had trouble checking the choice of root device. I'll assume that the root fs is still %s."), Root->name);
	    } else {
		sprintf (prtbuf, _("I had trouble checking the choice of root device. I don't know what to use as the root fs."));
	    }
	    problemBox (prtbuf, _("Problem"));
	}
	else if (! Root) {
	    Root = fdisk_find_partition_by_name (found_root);
	}
	else if (strcmp (Root->name, found_root)) {
	    sprintf (prtbuf, _("The root device has changed unexpectedly, from %s to %s."), Root->name, found_root);
	    problemBox (prtbuf, _("Root File System has Changed"));
	    Root = fdisk_find_partition_by_name (found_root);
	}
	if (found_root) {
            free (found_root);
	    found_root = NULL;
        }

#endif /* !_TESTING_ */

	boxPopWindow();

    done_keyboard:
	/* Start building menu entries. */

	next_action = alternate_action = alternate1_action = true;
	previous_action = previous1_action = true;
	bufA = bufA1 = bufP = bufP1 = "";

	if ((! NAME_ISREG (KEYBD_SETTINGS_FILE, &statbuf))
	    && NAME_ISEXE ("/sbin/loadkmap", &statbuf) 
	    && (serialConsole < 0)
	    && (!offerred_keyboard)
#if #cpu (m68k)
	    && (strcmp(Arch2, "VME") != 0)
#endif
#if #cpu (s390)
	    && 0                /* no keyboard settings for s390 needed*/ 
#endif
		) {

		offerred_keyboard = 1;
#if defined(USE_LANGUAGE_CHOOSER) && defined(USE_LANGUAGE_KEYMAPS)
		/* assert (lang != NULL); */
		if (lang->keymap != NULL && lang->keymap[0] != '\0')
		{
			/*
			 * MSS: I am not sure this is needed as we've already
			 * chosen the localized environment
			 */
			configure_keyboard (lang->keymap);
			goto done_keyboard;
		}
#endif

                /* check for boot-args (only if we're not already selected via the lang stuff) */
		if (bootargs.kbd) {
			configure_keyboard (bootargs.kbd);
			goto done_keyboard;
#ifdef KBD
                        
		} else {
                        /* change to keyboard defined in config (only if bootargs.kbd != NULL) */
			configure_keyboard (KBD);
			goto done_keyboard;
#endif
		}


		next_action = configure_keyboard_m;
		bufT = _("You must indicate what sort of keyboard you have so that keys operate as expected.  Select \"Next\" from the menu to configure your keyboard.");
		bufN = _("Configure the Keyboard");
#if ( #cpu(i386) )
		/* TRANS: keep it short */ 
		bufA = _("Preload essential modules from a floppy");
		alternate_action = load_modules_after_boot;
#endif
		/*
		 * Alternate step:
		 *
		 *  Configure the network instead of partitioning hard
		 *  drives, in case there are no hard drives connected
		 *  to the host.  This is to support diskless NFS-root
		 *  installations.
		 *
		 */
		if (fdisk_disks) {
#if ( #cpu(i386) )
			if ( ! load_modules_after_boot_ac() ) {
				alternate_action = load_modules_after_boot;
				bufA = _("Preload essential modules from a floppy");
				alternate1_action = partition_disk;
				bufA1 = _("Partition a Hard Disk");
			} else {
#endif
				alternate_action = partition_disk;
				bufA = _("Partition a Hard Disk");
#if ( #cpu(i386) )
			}
#endif
		}
		else {
			alternate_action = configure_hostname;
			bufA = _("Configure the hostname");
		}
	}
	else if ((swapon_partitions == NULL)
		 && (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL)
#if ( #cpu(s390) )
		 && (fdisk_disks != NULL)
#endif
		 && (noSwap == 0)) {
		/*
		 * No "Linux swap" partitions have been created.
		 */
		next_action      = partition_disk;
		alternate_action = no_swap;
		bufT = _("A swap partition is strongly recommended to provide virtual memory for your system, yet none was detected.  Selecting \"Next\" will start the partitioning program.  Use that to create \"Linux native\" and \"Linux swap\" partitions on your disks.  If you don't want a swap partition, select \"Alternate\".");
		bufN = _("Partition a Hard Disk");
		bufA = _("Do Without a Swap Partition");
#if ( #cpu(i386) )
		if ( ! load_modules_after_boot_ac() ) {
			alternate1_action = load_modules_after_boot;
			bufA1 = _("Preload essential modules from a floppy");
		}
#elif ( #cpu(s390) )
		alternate1_action = attach_disk;
		bufA1 = _("Attach a Disk");
#endif
	}
#if ( #cpu(s390) ) &&  !defined(NFSROOT)
	else if ((! Root) && (fdisk_disks == NULL) ) {
		/*
		 * No disks found:
		 *
		 * Attach disk dynamically.
		 */
		next_action = attach_disk;
		bufN = _("Attach a Disk");
		bufT = _("No hard disk drives were detected.  You need to attach disks dynamically.  Select \"Next\" to attach a disk.");
	}
#endif
	else if ((! Root) && (fdisk_disks == NULL) && is_network_up(0)) {
		 /*
		  * No disks found, but ethernet is up
		  *
		  * Rough guess: The user plans to use NFS-Root, so let him mount
		  * the partition.
		  */
		next_action = mount_any;
		bufN = _("Mount a Previously-Initialized Partition");
#if ( #cpu(i386) )
		alternate_action = load_modules_after_boot;
		bufA = _("Preload essential modules from a floppy");
		bufT = _("No hard disk drives could be found and the network is configured.  Please select \"Next\" to mount the root filesystem via NFS.  Select \"Alternate\" instead if you need to load essential modules from a floppy to make the hard disk drives visible.");
#elif ( #cpu(s390) )
		alternate_action = attach_disk;
		bufA = _("Attach a Disk");
		bufT = _("No hard disk drives could be found and the network is configured.  Please select \"Next\" to mount the root filesystem via NFS.  Select \"Alternate\" instead if you want to attach a disk.");
#else
		bufT = _("No hard disk drives could be found and the network is configured.  Please select \"Next\" to mount the root filesystem via NFS.");
#endif
	}
#if ( #cpu(i386) )
	else if ((! Root) && (fdisk_disks == NULL) && (! load_modules_after_boot_ac ())) {
		/*
		 * No disks found:
		 *
		 * Maybe essential modules need to be preloaded so the kernel
		 * knows about the drives.
		 */
		next_action = load_modules_after_boot;
		alternate_action = configure_network;
		bufN = _("Preload essential modules from a floppy");
		bufA = _("Configure the Network");
		bufT = _("No hard disk drives were detected.  You either need to load special drivers from a floppy, or you plan to install the system on a diskless workstation which uses NFS in place of local disk.  Select \"Next\" to load essential modules from a floppy, or \"Alternate\" to configure the network.");
	}
#endif

	else if ((! Root) && (fdisk_disks == NULL) && (! is_network_up(0))) {
		 /*
		  * Diskless install:
		  *
		  * Need to configure the network before mounting "/target".
		  */
		next_action = configure_network;
		bufT = _("No hard disk drives were detected.  Since you must be installing a diskless workstation, you must configure the network before mounting your Linux root filesystem from a NFS server.  Select \"Next\" to configure the network."); 
		bufN = _("Configure the Network");
#if ( #cpu(i386) )
		if ( ! load_modules_after_boot_ac() ) {
			alternate_action = load_modules_after_boot;
			bufA = _("Preload essential modules from a floppy");
		}
#endif
	}
	else if((! Root) && (fdisk_disks != NULL) && (fdisk_partitions_by_type[FSTYPE_EXT2] == NULL)) {
		/*
		 * No "Linux native" partitions have been created.
		 */
		next_action = partition_disk;
		bufT = _("No Linux partitions were detected.  At least one Linux partition is required to hold the root filesystem.  Selecting \"Next\" will start the partitioning program.  Use that to create \"Linux native\" partitions on your local disk.");
		bufN = _("Partition a Hard Disk");
#if ( #cpu(s390) )
		alternate_action = attach_disk;
		bufA = _("Attach a Disk");
#endif
	}
	else if ((swapon_partitions == NULL) && (noSwap == 0)) {
		/*
		 * The swap partition(s) are not initialized and
		 * activated.
		 */
		next_action       = init_swap;
		alternate_action  = activate_swap;
		alternate1_action = no_swap;
		previous_action   = partition_disk;
		bufT = _("You have a swap partition, but it needs to be initialized and activated.  Select \"Next\" to put this swap partition to use, providing virtual memory for your system.  Select \"Alternate\" to activate a swap partition which has already been initialized for swap.\n\nIf you have not finished partitioning your disks, select \"Previous\".  If you do not want to use your swap partition, select \"Alternate1\".");
		bufN = _("Initialize and Activate a Swap Partition");
		bufA = _("Activate a Previously-Initialized Swap Partition");
		bufA1 = _("Do Without a Swap Partition");
		bufP = _("Partition a Hard Disk");
	}
	else if (! Root && fdisk_disks != NULL) {
		/*
		 * The root partition has not been mounted.
		 */
		next_action      = init_linux;
		alternate_action = mount_any;
		bufT = _("There are Linux partitions present on your system, but none are mounted. You must mount a partition as the root filesystem before continuing.  If you have just created the partitions, select \"Next\" to initialize (or \"format\") a partition.  If you have partitions which have already been initialized, use \"Alternate\" to mount them without initialization.");
		bufN = _("Initialize a Linux Partition");
		bufA = _("Mount a Previously-Initialized Partition");
#if ( #cpu(s390) )
		alternate1_action = attach_disk;
		bufA1 = _("Attach a Disk");
#endif
	}
	else if (! Root && fdisk_disks == NULL) {
		/*
		 * The root partition has not been mounted, and this
		 * is a diskless NFS-root install.
		 */
		next_action = mount_any;
		bufT = _("You must mount a root filesystem before continuing.  Since you have no local disk, you probably want to mount the root filesystem over the network from an NFS server.  Selecting \"Next\" will let you do that.");
		bufN = _("Mount a Previously-Initialized Partition");
	}
	else if (((! NAME_ISREG ("/target/vmlinuz", &statbuf)) /* Assumes that NAME_ISREG uses stat() and thus follows the symlink. #### */
		  && (! NAME_ISREG ("/target/vmlinux", &statbuf))
		  && (! NAME_ISREG ("/target/boot/vmlinuz", &statbuf)) /* The link is moved to /boot on some platforms, eg. hppa */
		  && (! NAME_ISREG ("/target/boot/vmlinux", &statbuf))) /* powerpc needs this */
		 || (! NAME_ISREG ("/target/usr/share/modconf/descr.gz", &statbuf))) {
		/*
		 * The operating system kernel and the modules have
		 * not been installed.
		 */
		next_action               = extract_kernel_and_modules;
		bufT = _("You've mounted your root filesystem.  You may initialize and mount additional filesystems, or you may go on to install the operating system kernel and the modules.");
		bufN = _("Install Kernel and Driver Modules");
		if (fdisk_disks != NULL) {
			alternate_action  = init_linux;
			alternate1_action = mount_any;
			bufA = _("Initialize a Linux Partition");
			bufA1 = _("Mount a Previously-Initialized Partition");
		}
		else {
			alternate_action  = mount_any;
			bufA = _("Mount a Previously-Initialized Partition");
		}
	}
	else if (! NAME_ISREG ("/target/etc/modules", &statbuf)) {
		/*
		 * The modules have not been configured.
		 */
		next_action              = configure_drivers;
		bufN = _("Configure Device Driver Modules");
#ifdef PCMCIA
		if (! NAME_ISREG ("/target/etc/pcmcia.conf", &statbuf)) {
			bufT = _("You've installed the operating system kernel and the modules.  Please select \"Next\" to configure the device driver modules, \"Alternate\" if you have to configure any PCMCIA devices or \"Alternate1\" to install 3rd party modules."); 
			alternate_action = configure_pcmcia;
			bufA = _("Configure PCMCIA Support");
			alternate1_action = add_modules_from_floppy;
			bufA1 = _("Install Foreign Modules");
		} else
#endif
		{
#if !(#cpu(s390))
			alternate_action = add_modules_from_floppy;
			bufA = _("Install Foreign Modules");
#endif
#if (#cpu(alpha) || #cpu(m68k))
			if (!strlen(append_opts)) {
	    		    alternate1_action = edit_append_line;
	    		    bufA1 = _("Edit Kernel Boot Parameters");
			}
#endif
			bufT = _("You've installed the operating system kernel and the modules.  Please select \"Next\" to configure the device driver modules or \"Alternate\" to install 3rd party modules.");
		}
	}
	else if (! NAME_ISREG(target_path(NC_HOSTNAME_FILE),&statbuf) && !is_network_up(1)) {
		/*
		 * The hostname has not been configured, and it looks like we
		 * may not have any network devices, so let's configure
		 * the hostname here. The network config can override this
		 * if the user chooses to do so.
		 */
		next_action	= configure_hostname;
		bufN = _("Configure the hostname");
		alternate_action = configure_drivers;
		bufA = _("Configure Device Driver Modules");
		bufT = _("No network devices are available, therefore, you must set your hostname rather than fully configuring the network.\n\nIf you do have a network device, it is not currently being detected, so you should select \"Alternate\" to attempt to load a kernel driver for it.");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
		if (!strlen(append_opts)) {
			alternate1_action = edit_append_line;
			bufA1 = _("Edit Kernel Boot Parameters");
		}
#endif
	}
	else if ((! is_network_configured() || ! is_network_up(0)) && is_network_up(1)) {
		/*
		 * The network has not been configured and made active.
		 */
		next_action      = configure_network;
		if (is_network_up(0))
		    bufT = _("Your network is active, but it has not been configured for the system to remember.  If your system is configuring itself via hardware (i.e., your system can setup its network before Linux boots through DHCP or BOOTP), you should still setup the configuration so that the network can be brought up and down after booting.  If you configured the network yourself, then you also need to perform this step.");
		else if (is_network_configured())
		    bufT = _("Your network is configured, but not activated.  This may be caused by a broken previous installation attempt, or because you are installing over another installation.  It is ok to skip this step if you do not need to use the network for the rest of the installation, since your network will become active after reboot (assuming it is setup properly).");
		else
		    bufT = _("You have a network device, but it is not yet configured.  Please select \"Next\" to configure the network.");
		bufN = _("Configure the Network");
		if (! NAME_ISREG ("/target/etc/debian_version", &statbuf)
		    || ! NAME_ISREG ("/target/sbin/init", &statbuf)
		    || failedBaseInstall) {
			alternate_action = main_menu_extract_base;
			bufA = _("Install the Base System");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc)) || #cpu(powerpc)
			if (!strlen(append_opts)) {
				alternate1_action = edit_append_line;
				bufA1 = _("Edit Kernel Boot Parameters");
			}
#endif
		}
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc)) || #cpu(powerpc)
		else {
			if (!strlen(append_opts)) {
				alternate_action = edit_append_line;
				bufA = _("Edit Kernel Boot Parameters");
			}
		}
#endif
	}
	else if (! NAME_ISREG ("/target/etc/debian_version", &statbuf)
		 || ! NAME_ISREG ("/target/sbin/init", &statbuf)
		 || failedBaseInstall) {
		/*
		 * The base system has not been installed.
		 */
		next_action = main_menu_extract_base;
		if (failedBaseInstall) {
			bufT = _("The previous attempt to install the base system failed. Please select \"Next\" to retry installation of the base system.");
		} else {
			bufT = _("The next step is to install essential software for your new Debian GNU/Linux system.  This is called the base system.  It will be installed to the disks you have already mounted.");
		}
		bufN = _("Install the Base System");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc)) || #cpu(powerpc)
		if (!strlen(append_opts)) {
			alternate_action = edit_append_line;
			bufA = _("Edit Kernel Boot Parameters");
		}
#endif
	}
	else if (notCreatedBootFloppy && notInstalledLILO && ! is_nfs_partition ("/target")
#if #cpu(m68k)
		 && (strcmp(Arch2, "Mac") != 0)
#endif
		) {
		/*
		 * Reboot, chroot, or create a boot floppy.
		 */
		next_action               = make_bootable;
#if !(#cpu(s390) || #cpu(hppa) || #cpu(ia64) || #cpu(mips) || #cpu(mipsel))
		alternate_action          = make_boot_floppy;
#endif
		if (initchroot_cap())
			alternate1_action = chroot_start;
		else
#if !(#cpu(s390))
			alternate1_action = reboot_system;
#else
			alternate1_action = halt_system;
#endif
		bufT = _("Select \"Next\" to configure your system to boot into Debian when powered on.  The \"Alternate\" step will make a custom floppy for booting; this is a good option if you don't want to change how your system currently boots up (for instance, you have another operating system installed).  Select \"Alternate1\" to simply reboot the system, which is appropriate if you have other means of booting, or have configured booting on your own.");
		bufN = _("Make System Bootable");
#if !(#cpu(s390) || #cpu(hppa) || #cpu(ia64) || #cpu(mips) || #cpu(mipsel))
		bufA = _("Make a Boot Floppy");
#endif
		if (initchroot_cap())
			bufA1 = _("Start New System");
		else
			bufA1 = _("Reboot the System");
	}
	else if (notCreatedBootFloppy
#if #cpu(m68k)
		 && (strcmp(Arch2, "Mac") != 0)
#endif
#if #cpu (s390) || #cpu(hppa) || #cpu(ia64) || #cpu(mips) || #cpu(mipsel)
	    && 0                /* no boot floppy for s390, hppa, ia64 or mips(el) */ 
#endif
		) {
		/*
		 * The boot floppy has not been created.
		 */
		next_action              = make_boot_floppy;
		if (initchroot_cap())
			alternate_action = chroot_start;
		else
#if !(#cpu(s390))
			alternate_action = reboot_system;
#else
			alternate_action = halt_system;
#endif
		bufT = _("Debian is now installed (although not yet fully configured).\n\nYou should build a custom boot floppy, in case Debian GNU/Linux doesn't boot  directly from the hard disk.  Please select \"Next\" to build the custom boot floppy.");
		bufN = _("Make a Boot Floppy");
		if (initchroot_cap())
			bufA = _("Start New System");
		else
			bufA = _("Reboot the System");
	}
	else if (initchroot_cap()) {
		/*
		 * Chroot or reboot.
		 */
		next_action      = chroot_start;
		alternate_action = reboot_system;
		bufT = _("It's time to start your new Debian GNU/Linux system.  Select \"Next\" to bootstrap your machine without reboot and complete the remaining configuration.");
		bufN = _("Start New System");
		bufA = _("Reboot the System");
	} else {
		/*
		 * Nothing left to do but reboot the system.
		 */
#if !(#cpu(s390))
		next_action = reboot_system;
#else
		next_action = halt_system;
#endif
		bufT = _("It's time to start your new Debian GNU/Linux system.  Select \"Next\" to reboot your machine and complete the remaining configuration.  If your system has troubles booting, you may have to fall back to your custom boot disk, or the rescue disk -- see the documentation.");
		bufN = _("Reboot the System");
	}

	items = 0;
	choices[items].tag    = _("Next");
	choices[items].string = bufN;
	ilist[items] = OPT_Next;
	items++;
	if (bufA[0]) {
	    choices[items].tag    = _("Alternate");
	    choices[items].string = bufA;
	    ilist[items] = OPT_Alternate;
	    items++;
	}
	if (bufA1[0]) {
	    choices[items].tag    = _("Alternate1");
	    choices[items].string = bufA1;
	    ilist[items] = OPT_Alternate1;
	    items++;
	}
	if (bufP[0]) {
	    choices[items].tag    = _("Previous");
	    choices[items].string = bufP;
	    ilist[items] = OPT_Previous;
	    items++;
	}
	if (bufP1[0]) {
	    choices[items].tag    = _("Previous1");
	    choices[items].string = bufP1;
	    ilist[items] = OPT_Previous1;
	    items++;
	}
	items++;
#if (#cpu(powerpc))
	if (strcmp(Arch2, "apus") == 0)
	    for (i = 0 ; entries_apus[i].string ; i++) {
		choices[items].string = entries_apus[i].string;
		ilist[items] = entries_apus[i].key;
		items++;
	    }
	else    
#endif
	for (i = 0 ; entries[i].string ; i++) {
	    choices[items].string = entries[i].string;
	    ilist[items] = entries[i].key;
	    items++;
	}

	rs = menuBox (bufT, _("Debian GNU/Linux Installation Main Menu"), choices, items, 0);
	data = ilist[rs];

#ifndef _TESTING_
	switch (data) {
	    case OPT_Next:             next_action(); break;
	    case OPT_Alternate:        alternate_action(); break;
	    case OPT_Alternate1:       alternate1_action(); break;
	    case OPT_Previous:         previous_action(); break;
	    case OPT_Previous1:        previous1_action(); break;

	    case OPT_CONFIGURE_KEY:    configure_keyboard_m(); break;
	    case OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT: load_modules_after_boot(); break;
	    case OPT_PARTITION_DISK:   partition_disk(); break;
	    case OPT_INITIALIZE_SWAP:  init_swap(); break;
	    case OPT_ACTIVATE_SWAP:    activate_swap(); break;
	    case OPT_DO_WITHOUT_SWAP:  no_swap(); break;
	    case OPT_INITIALIZE_LINUX: init_linux(); break;
	    case OPT_MOUNT_LINUX:      mount_any(); break;
	    case OPT_UMOUNT_LINUX:     unmount_any(); break;
	    case OPT_CONFIGURE_HOSTNAME: configure_hostname(); break;
	    case OPT_KERNEL_APPEND:	edit_append_line(); break;
	    case OPT_INSTALL_OS:
	      if (Root) {
		extract_kernel_and_modules(); 
	      } else { require_root(); } break;
	    case OPT_INSTALL_BASE:
	      if (Root) {
		main_menu_extract_base();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_MODULES:
	      if (Root) {
		configure_drivers();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_NET:    configure_network(); break;
	    case OPT_DISK_BOOT:
	      if (Root) {
		make_bootable();
	      } else { require_root(); } break;
	    case OPT_FLOPPY_BOOT:
	      if (Root) {
		make_boot_floppy();
	      } else { require_root(); } break;
	    case OPT_START_NEW_SYSTEM: chroot_start(); break;
	    case OPT_REBOOT:
#if !(#cpu(s390))
		reboot_system(); break;
#else
		halt_system(); break;
#endif
	    case OPT_VIEW_PARTITIONS:  view_partitions(); break;
	    case OPT_EXECUTE_SHELL:    interactive_shell(); break;
#ifdef PCMCIA
	    case OPT_CONFIGURE_PCMCIA:
	      if (Root) {
		configure_pcmcia();
	    } else { require_root(); } break;
#endif 
#ifdef DO_EJECT
	    case OPT_EJECT_FLOPPY: do_eject(); break;
#endif
	    case OPT_RESTART_DBOOTSTRAP: 
	      {  boxFinished();
#if #cpu(s390)
	      if(!NAME_ISDIR("/target/etc", &statbuf) && !fdisk_find_partition_by_mntpoint ("/target")) {
              /* restore resolv.conf in case /target has been unmounted */
	        execlog("rm -f /etc/resolv.conf", LOG_INFO);
	        execlog("cp -a /tmp/resolv.conf /etc/resolv.conf", LOG_INFO);
              }
	      if(NAME_ISDIR("/lib/modules.old", &statbuf) && !fdisk_find_partition_by_mntpoint ("/target")) {
	      /* restore old modules directory */   
	        execlog("rm -rf /lib/modules", LOG_INFO);
	        execlog("mv /lib/modules.old /lib/modules", LOG_INFO);
	      }
#endif
	      exit (-1); }
	    case OPT_PROBLEM_REPORT:   generate_problem_report(); break;
	    case OPT_FOREIGN_MODULES:  add_modules_from_floppy(); break;
#if (#cpu(s390))
	    case OPT_ATTACH_DISK:
		attach_disk(); break;
#endif
	    default: assert(0);
	}
#else  // _TESTING_
        sprintf (prtbuf, "You've chosen item: %d", data);
        problemBox (prtbuf, "Option chosen");
	if (data == OPT_REBOOT) return(0);
#endif // _TESTING_
    }
    return 0;
}

#ifdef _TESTING_

/*
 * To test, compile using: make main_menu_test
 */
int main ()
{
	LOAD_TRMFILE ("test.trm");
	get_kver();
	boxInit();
	main_menu();
	boxFinished();
}
#endif

/* vi: set sw=8 ts=8: */
/*
 * Local Variables:
 * c-file-style: "linux"
 * End:
 */
