#ifndef _BRAHMSMIDIRECORDER_CPP_
#define _BRAHMSMIDIRECORDER_CPP_

#include "BrahmsArts.h"

using namespace Arts;
using namespace std;


class BrahmsMidiRecorder_impl : virtual public BrahmsMidiRecorder_skel
{
private:
  MidiPort midiThru;
  vector<MidiEvent> * midiEventQueue;
  bool _record;

  void addToList(const MidiEvent & ev) {
    if (_record) midiEventQueue->push_back(ev);
  }

public:
  BrahmsMidiRecorder_impl() : _record(false) {
    midiEventQueue = new vector<MidiEvent>();
  }
  
  ~BrahmsMidiRecorder_impl() {
    delete midiEventQueue;
  }

  /**
   * the current absolute time (since the existence of the midi device)
   */
  TimeStamp time() {
    return midiThru.time();
  }
  
  /**
   * processes a midi command
   */
  void processCommand(const MidiCommand & command) {
    midiThru.processCommand(command);
    TimeStamp ts = midiThru.time();
    addToList(MidiEvent(ts,command));
  }
  
  /**
   * processes a midi event
   */
  void processEvent(const MidiEvent & event) {
    midiThru.processEvent(event);
    addToList(event);
  }
  

  bool record() {
    return _record;
  }

  void record(bool r) {
    _record = r;
  }

  vector<MidiEvent> * getQueue() {
    vector<MidiEvent> * foo = midiEventQueue;
    midiEventQueue = new vector<MidiEvent>();
    return foo;
  }

  void setMidiThru(MidiPort port) {
    midiThru = port;
  }


};

REGISTER_IMPLEMENTATION(BrahmsMidiRecorder_impl);

#endif
