#ifndef _SCORETRACK_H_
#define _SCORETRACK_H_

#include "track.h"

class ScoreTrack : public Track
{
 private:
  int _channel;
  int _program;
  int _output;
  int _volume;
  int _delay;
  int _transpose;

  bool _print_in_partiture;
  int _print_in_piano_system;

 public:
  ScoreTrack();
  ScoreTrack(const ScoreTrack&);
  ~ScoreTrack();

  int channel() const { return _channel; }
  int program() const { return _program; }
  int output() const { return _output; }
  int volume() const { return _volume; }
  int delay() const { return _delay; }
  int transpose() const { return _transpose; }

  void setChannel(int);
  void setProgram(int);
  void setOutput(int);
  void setVolume(int);
  void setDelay(int);
  void setTranspose(int);

  // virtual void hide();
  // virtual void show();

  virtual ostream & printOptions(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

  void loadOpt(ifstream*&);

  /* for printing */

  /** Print-in-Partiture: returns true if this track is to be printed in a partiture */
  bool PiP() const { return _print_in_partiture; }

  /** Print-in-Piano-System: returns where this track shall be printed within a piano system: 0=skip, 1=treble, 2=bass */
  int PiPS() const { return _print_in_piano_system; }

  /** sets the Print-in-Partiture flag */
  void sPiP(bool p);

  /** sets the Print-in-Piano-System position: 0=skip, 1=treble, 2=bass */
  void sPiPS(int p);

};

#endif
