#ifndef _SCOREITERATOR_H_
#define _SCOREITERATOR_H_

//
// usage:
//
// gi = new ScoreIterator(_editor);  // respects left and right positions
//
// for (ScoreIterator gi = ScoreIterator(_editor); !gi.done(); gi++) {
//   draw(gi);
// }
//
//
//
//
//
//


#include "position.h"
#include "iterator.h"
#include "table.h"

class PrPartEditor;
class Track;
class Part;
class Event;
class Note;


class ScoreIterator
{
 private:
  Part *      _part;
  Iterator ** _iterator;
  int         _systems;
  Table *     _score;
  int         _ptr;
  int         _max;
  int         _res;
  bool        _no_overlap;
  double      _scale;
  int         _width;
  struct InitState * state;
  void add(int sys, Note * note, long len=0, Position pos=0);
  void nextbar();

 public:
  ScoreIterator(const ScoreIterator& i);
  
  ScoreIterator(Track * track);
  
  ScoreIterator(Part * part, Position left = 0, Position right = 0);

  ScoreIterator(PrPartEditor * editor);

  ~ScoreIterator();

  /** creates the Score from the events
   */
  void init();
  
  bool done();

  bool reallyDone(int sys);

  long truncEnd(Note * note);

  Element * operator *();
  
  Iterator& operator++();
  
  Iterator operator++(int);

};

#endif
