#ifndef _KDEFACTORY_CPP_
#define _KDEFACTORY_CPP_

#include "config.h"
#include "arts/objectmanager.h"

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include <dlfcn.h>
#include <iostream.h>

#include "prFactory.h"

#include "kdeMainEditor.h"
#include "kdeFactory.h"
#include "kdeScoreTrack.h"
#include "kdeDrumTrack.h"
#include "kdeMasterTrack.h"
#include "kdeAudioTrack.h"
#include "kdeCommentTrack.h"
#include "kdePart.h"
#include "kdeScorePainter.h"

class KdeTrack;

extern "C" {
  PrFactory * libBrahmsKdePresentation() { return new KdeFactory(); }
}


KdeFactory::~KdeFactory() {
  delete dispatcher;
  delete qiomanager;
  delete brahms;
}

PrMainEditor * KdeFactory::createMainEditor(int argc, char** argv) {
  brahms = new KApplication( argc, argv, "brahms" );
  qiomanager = new Arts::QIOManager();
  dispatcher = new Arts::Dispatcher(qiomanager);
  Arts::ObjectManager::the()->provideCapability("kdegui");
  KdeMainEditor * widget = new KdeMainEditor( "Brahms", brahms, argc, argv );
  brahms->setMainWidget( widget );
  return widget;
}

PrTrack * KdeFactory::createScoreTrack(Track * tr) {
  KdeTrack * kdetr = new KdeScoreTrack(tr);
  kdetr->show();
  return kdetr;
}

PrTrack * KdeFactory::createDrumTrack(Track * tr) {
  KdeTrack * kdetr = new KdeDrumTrack(tr);
  kdetr->show();
  return kdetr;
}

PrTrack * KdeFactory::createMasterTrack(Track * tr) {
  KdeTrack * kdetr = new KdeMasterTrack(tr);
  kdetr->show();
  return kdetr;
}

PrTrack * KdeFactory::createAudioTrack(Track * tr) {
  KdeTrack * kdetr = new KdeAudioTrack(tr);
  kdetr->show();
  return kdetr;
}

PrTrack * KdeFactory::createCommentTrack(Track * tr) {
  KdeTrack * kdetr = new KdeCommentTrack(tr);
  kdetr->show();
  return kdetr;
}

PrPart * KdeFactory::createPart(Part * pt) {
  KdePart * kdept = new KdePart(pt);
  kdept->show();
  return kdept;
}

PrScorePainter * KdeFactory::getScorePainter() {
  if (scorePainter==0) scorePainter = new KdeScorePainter();
  return scorePainter;
}

#endif

// vim:sw=2:ai
