#ifndef _KDEPIANOROLLEDITOR_H_
#define _KDEPIANOROLLEDITOR_H_

#include <kmainwindow.h>

#include "prPartEditor.h"


class Part;
class QSplitter;
class QScrollView;
class QScrollBar;
class QWidget;
class QFrame;
class QPaintEvent;
class QResizeEvent;
class KdePianoContent;
class KdeEditorToolBar;
class KdeEditorNoteBar;
class KdeEditorButtonBar;
class KdeEditorScrollBar;
class KdeEditInfo;

class KdePianoRollEditor : public KMainWindow, public PrPartEditor
{
  Q_OBJECT

 private:
  QSplitter       * _splitter;
  QScrollView     * _scroller;
  QPopupMenu      * _filemenu;
  QPopupMenu      * _editmenu;
  QPopupMenu      * _gridmenu;
  QPopupMenu      * _dynamicsmenu;
  QPopupMenu      * _viewmenu;
  KdeEditorToolBar * _toolbar;
  KdeEditorNoteBar * _notebar;
  KdeEditorButtonBar * _buttonbar;
  KdeEditorScrollBar * _scrollbar;
  KdePianoContent * _content;
  KdeEditInfo     * _info;
  int _yoffset;
  int _ybottom;
  int _grid_id;
  int _dyn_id;
  bool _toolbarstate;
  bool _notebarstate;
  bool _buttonbarstate;
  bool _sliderstate;

 public:
  KdePianoRollEditor();
  KdePianoRollEditor(Part * p);
  KdePianoRollEditor(Track * t);
  ~KdePianoRollEditor();
  void run();

  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);
  // from former version:

 public slots:
  void paintEvent ( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void slotMenu( int );
  void slotGridMenu( int );
  void slotDynMenu( int );
  void slotViewMenu( int );

};

#endif
