#ifndef _KDESPD_H_
#define _KDESPD_H_

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <qcombobox.h>

class PrPartEditor;

class KdeSPD : public QLabel
{
  Q_OBJECT
 private:
  PrPartEditor * _editor;
  QTabDialog * dialog;
  QGroupBox * group1;
  QGroupBox * group2;
  QWidget * pref1;

  QLabel * label;
  QCheckBox * partiture[128];
  QComboBox * pianosys[128];
  QCheckBox * ppbox;
  QCheckBox * ppsbox;

  bool ppValue[128];
  int ppsValue[128];
  int systems;

 public:
  KdeSPD( QWidget * parent , const char * name , PrPartEditor * e );


public slots:

  void ppboxUpdate();
  void ppsboxUpdate();
  void partitureUpdate();
  void pianosysUpdate(int);
  void printme();
  void cancelme();

};
#endif
