/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: kspinboxaction.h,v 1.1 2001/07/23 08:16:59 mkretz Exp $ */

#ifndef KSPINBOXACTION_H
#define KSPINBOXACTION_H

#include <qguardedptr.h>

#include <kaction.h>

class QSpinBox;
class QObject;

class KSpinBoxAction : public KAction
{
	Q_OBJECT
public:
	KSpinBoxAction( int minValue, int maxValue, int step, const QString& text, QObject* parent, const char* name );
	virtual ~KSpinBoxAction();

	virtual int plug( QWidget *w, int index = -1 );
	 
	virtual void unplug( QWidget *w );

	QGuardedPtr<QSpinBox> spinbox() { return m_spinbox; }

	virtual void setPrefix( const QString & );
	virtual void setValue( int );

signals:
	void plugged();
	void valueChanged( int );

private:
	QGuardedPtr<QSpinBox> m_spinbox;
	int m_min, m_max, m_step;
	QString m_prefix;
	int m_value;
};

#endif //KSPINBOXACTION_H

// vim:tw=4:sw=4
