#ifndef _AUDIOTRACK_CPP_
#define _AUDIOTRACK_CPP_

#include <iostream.h>
#include "audioTrack.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "prTrack.h"
#include "prFactory.h"

extern PrFactory * factory;


AudioTrack::AudioTrack()
{
  _type = AUDIOTRACK;
  _pr = factory->createAudioTrack(this);
}

AudioTrack::AudioTrack(const AudioTrack& st)
  : Track(st,AUDIOTRACK)
{
    _pr = factory->createAudioTrack(this);
}

AudioTrack::~AudioTrack() {
}

ostream & AudioTrack::printOptions(int /*dep*/, ostream & s) const {
  // s << spc(dep) << "<OPTIONS ";
  // s << " file=\"" << _file << "\"";
  // s << " />" << endl;
  return s;
}

void AudioTrack::flush(const char * c) const {
  cout << c << "AUDIOTRACK" << endl;
}

Element * AudioTrack::copy() const {
  return new AudioTrack(*this);
}

void AudioTrack::loadOpt(ifstream *& ) { // inPtr
  // Table * opt = Loader::getAttributes("OPTIONS",inPtr);

  // opt->scratch();
  // delete opt;
}


#endif
