#ifndef _DELETESELECTION_CPP_
#define _DELETESELECTION_CPP_

#include <iostream.h>

#include "deleteSelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "event.h"
#include "song.h"
#include "part.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;


DeleteSelection::DeleteSelection(Compound * pt) : Operation(),
                                                  _selection(0), _comp(pt), _scratch(false) {
  _type = DELETESELECTION;
  _description = "delete selection";
  _to_be_undone = true;
  _selection = selectioN;

  selectioN = new Table();
  Element * ev = 0;
  for (Reference * r = (Reference*)_selection->first(); r != 0; r = (Reference*) Element::next(r)) {
    ev = r->getValue();
    _comp->remove(ev);
    ev->hide();
  }
  _scratch = true; // notes are unused! Delete them when destructing
}


DeleteSelection::DeleteSelection(const DeleteSelection& el) : Operation(el) {
  _type = DELETESELECTION;
  _selection = el._selection;
  _comp   = el._comp;
  _scratch = el._scratch;
}

DeleteSelection::~DeleteSelection() {
  if (_selection!=0) {
    if (_scratch) _selection->scratch();
    else          ((Compound*)_selection)->scratch();
    delete _selection;
  }
}

void DeleteSelection::undo() {
  // Table * tmp = selectioN;
  // selectioN = _selection; // do we want to reappear the selection? If so, be sure to clear selectioN if != 0
  // _delete = _oldTable;
  // now put events back into the part:
  // Element * ev = 0;
  for (Reference * r = (Reference*)_selection->first(); r != 0; r = (Reference*) Element::next(r)) {
    _comp->add(r->getValue());
    r->getValue()->show();
  }
  _scratch = false; // the notes are used again! Delete only their references when destructing!
}

void DeleteSelection::redo() {
  // Table * tmp = _oldTable;
  // _oldTable = selectioN;
  // selectioN = tmp;
  // _delete = _oldTable;
  // now remove the events from the part again:
  // Element * ev = 0;
  for (Reference * r = (Reference*)_selection->first(); r != 0; r = (Reference*) Element::next(r)) {
    _comp->remove(r->getValue());
    r->getValue()->hide();
  }
  _scratch = true; // notes are unused! Delete them when destructing
}



// ---------------
// virtuals:
//

ostream & DeleteSelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<DELETESELECTION />" << endl;
  return s;
}

void DeleteSelection::flush(const char * c) const {
  cout << c << "DELETESELECTION" << endl;
}

Element * DeleteSelection::copy() const {
  return new DeleteSelection(*this);
}




#endif
