#ifndef _DRUMTRACK_CPP_
#define _DRUMTRACK_CPP_

#include <iostream.h>
#include <stdlib.h>
#include "drumTrack.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "prTrack.h"
#include "prFactory.h"

extern PrFactory * factory;

DrumTrack::DrumTrack()
  : Track(), _channel(9), _program(0), _output(0), _volume(0), _delay(0), _transpose(0)
{
  _type = DRUMTRACK;
  _pr = factory->createDrumTrack(this);
}

DrumTrack::DrumTrack(const DrumTrack& dt)
  : Track(dt,DRUMTRACK)
{
    _channel = dt.channel();
    _program = dt.program();
    _output = dt.output();
    _volume = dt.volume();
    _delay = dt.delay();
    _transpose = dt.transpose();
    _pr = factory->createDrumTrack(this);
}


DrumTrack::~DrumTrack() {
}

void DrumTrack::setChannel(int i) {
  _channel = i;
}

void DrumTrack::setProgram(int i) {
  _program = i;
}

void DrumTrack::setOutput(int i) {
  _output = i;
}

void DrumTrack::setVolume(int i) {
  _volume = i;
}

void DrumTrack::setDelay(int i) {
  _delay = i;
}

void DrumTrack::setTranspose(int i) {
  _transpose = i;
}



ostream & DrumTrack::printOptions(int dep, ostream & s) const {
  s << spc(dep) << "<OPTIONS ";
  s << " program=\"" << _program << "\"";
  s << " channel=\"" << _channel << "\"";
  s << " output=\"" << _output << "\"";
  s << " volume=\"" << _volume << "\"";
  s << " transpose=\"" << _transpose << "\"";
  s << " delay=\"" << _delay << "\"";
  // s << " print=\"" << str->PiP() << "\"";
  // s << " printps=\"" << str->PiPS() << "\"";
  s << " />" << endl;
  return s;
}

void DrumTrack::flush(const char * c) const {
  cout << c << "DRUMTRACK" << endl;
}

Element * DrumTrack::copy() const {
  return new DrumTrack(*this);
}

void DrumTrack::loadOpt(ifstream *& inPtr) {
  Table * opt = Loader::getAttributes("OPTIONS",inPtr);
  int program = 0;
  int channel = 0;
  int output = 0;
  int volume = 0;
  int transpose = 0;
  int delay = 0;
  if (opt->getEntry("program")) program = atoi(((String*) opt->getEntry("program"))->getValue());
  if (opt->getEntry("channel")) channel = atoi(((String*) opt->getEntry("channel"))->getValue());
  if (opt->getEntry("output")) output = atoi(((String*) opt->getEntry("output"))->getValue());
  if (opt->getEntry("volume")) volume = atoi(((String*) opt->getEntry("volume"))->getValue());
  if (opt->getEntry("transpose")) transpose = atoi(((String*) opt->getEntry("transpose"))->getValue());
  if (opt->getEntry("delay")) delay = atoi(((String*) opt->getEntry("delay"))->getValue());
  setProgram(program);
  setChannel(channel);
  setOutput(output);
  setVolume(volume);
  setTranspose(transpose);
  setDelay(delay);

  opt->scratch();
  delete opt;
}


#endif
