#ifndef _MIDIEVENT_CPP_
#define _MIDIEVENT_CPP_

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "loader.h"
#include "table.h"
#include "str.h"
#include "midiEvent.h"



MidiEvent::MidiEvent() : _codechan(0), _value1(0), _value2(0) {
  _type = MIDIEVENT;
}

MidiEvent::MidiEvent(const MidiEvent& m) : Event(m) {
  _type = MIDIEVENT;
  _codechan = m.codeAndChannel();
  _value1 = m.value1();
  _value2 = m.value2();
}

MidiEvent::MidiEvent(Position pos, int cc, int value1, int value2)
  : Event(pos,0), _codechan(cc), _value1(value1), _value2(value2) {
  _type = MIDIEVENT;
}


void MidiEvent::setCodeAndChannel(int cc) { _codechan = cc; }

void MidiEvent::setValue1(int met0) { _value1 = met0; }

void MidiEvent::setValue2(int met1) { _value2 = met1; }



ostream & MidiEvent::print(int dep, ostream & s) const {
  s << spc(dep) << "<MIDIEVENT pos=\"" << internalStart().ticks() << "\" code=\"" << _codechan << "\" value1=\"" << _value1 << "\" value2=\"" << _value2 << "\" />" << endl;
  return s;
}

void MidiEvent::flush(const char * c) const {
  cout << c << "MIDIEVENT" << endl;
}

Element * MidiEvent::copy() const {
  return new MidiEvent(*this);
}



Element * MidiEvent::load(char * aline, ifstream *& inPtr, Element * parent) {
  MidiEvent * midiEvent = new MidiEvent();
  Table * attr = Loader::getAttributes("MIDIEVENT",aline);
  if (attr!=0) {
    int pos = 0;
    int code = 0;
    int val1 = 0;
    int val2 = 0;

    if (attr->getEntry("pos")) pos = atoi(((String*) attr->getEntry("pos"))->getValue());
    if (attr->getEntry("code")) code = atoi(((String*) attr->getEntry("code"))->getValue());
    if (attr->getEntry("value1")) val1 = atoi(((String*) attr->getEntry("value1"))->getValue());
    if (attr->getEntry("value2")) val2 = atoi(((String*) attr->getEntry("value2"))->getValue());

    midiEvent->setInternalStart(pos);
    midiEvent->setCodeAndChannel(code);
    midiEvent->setValue1(val1);
    midiEvent->setValue2(val2);

    attr->scratch();
    delete attr;
  }
  return midiEvent;
}



#endif
