#ifndef _NOTE_CPP_
#define _NOTE_CPP_

#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <fstream.h>
#include <stdlib.h>
#include "note.h"
#include "song.h"
#include "vector.h"
#include "str.h"
#include "loader.h"
#include "ornament.h"
#include "addOrnament.h"
#include "lyrics.h"
#include "riemannFunction.h"
#include "expression.h"
#include "reference.h"
#include "event.h"
#include "tuplet.h"


extern Song * sonG;
extern char * getcmd(char*);


/* Implementation of the property value _prop:
   -------------------------------------------

   The value _prop is an array of bits, holding the following information:

     80   40    20   10   08   04   02   01
   ------------------------------------------
   |    |    |     |    |    |    |    |    |
   ------------------------------------------
             |nogrp|  stem   | enh.shft + 2 |
             |     |         |              |
             |0:off| 0: auto | 0: bb 1: b   |
             |1:on | 2: auto | 2: n         |
             |     | 1: up   | 3: #  4: xx  |
             |     | 3: down | (5-7: undef.)|
   ------------------------------------------


   One more word to the tuplets:
   -----------------------------

   The tuplets are separate instances, holding information about
   the tuplet base and the total duration of that tuplet.
   The factor that corellates the displayed value (the display) of
   a tuplet with the actual duration is determined by:

                   2*n
         display = --- * duration
                   n+1

     tuplet:     factor:      base:

     pair:         4/3         2
     triplet:      3/2         3
     quintet:      5/3         5
     septet:       7/4         7
     n-tuplet:     2n/(n+1)    n

*/

Note::Note( )
  : Event(0,0), _pitch(0),_vel(0), _prop(2), _chan(-1), _tuplet(0), _ornament(new Vector()), _cPitch(new char[4]) { _type = NOTE; }

Note::Note(const Note& n) : Event(n) {
  _type = NOTE;

  _pitch = n.pitch();
  _vel = n.vel();
  _prop = n._prop;
  _chan = n.chan();
  _tuplet = n._tuplet;
  _ornament = (Vector*) n._ornament->copy();
  _cPitch = strdup(n._cPitch);
}

Note::Note(int pitch, int vel, long len, Position pos, int enh, int tup, int chan)
  : Event(pos,len), _pitch(pitch),_vel(vel), _prop(enh+2), _chan(chan), _tuplet(0), _cPitch(new char[4]) {
  _ornament = new Vector();
  if (tup != 0) _tuplet = new Tuplet(tup,len);
  _type = NOTE;
}

Note::Note(char * pitch, int vel, long len, Position pos, int enh, int tup, int chan)
  : Event(pos,len), _vel(vel), _prop(enh+2), _chan(chan), _tuplet(0), _cPitch(new char[4]) {
  _ornament = new Vector();
  if (tup != 0) _tuplet = new Tuplet(tup,len);
  _type = NOTE;
  int o = atoi(pitch+1);
  if (o==0) o = atoi(pitch+2);
  int f = 24;
  switch (pitch[0]) {
  case 'c': f = 24; break;
  case 'd': f = 26; break;
  case 'e': f = 28; break;
  case 'f': f = 29; break;
  case 'g': f = 31; break;
  case 'a': f = 33; break;
  case 'h': f = 35; break;
  case 'b': f = 35; break;
  case 'C': f = 24; break;
  case 'D': f = 26; break;
  case 'E': f = 28; break;
  case 'F': f = 29; break;
  case 'G': f = 31; break;
  case 'A': f = 33; break;
  case 'H': f = 35; break;
  case 'B': f = 35; break;
  }
  switch (pitch[1]) {
  case '#': f+=1; break;
  case 'b': f-=1; break;
  }
  f+=12*o;
  _pitch = f;
}


Note::~Note() {
  delete _ornament;
  delete _cPitch;
  delete _tuplet;
}

Tuplet * Note::tuplet() const {
  if (_tuplet==0) return 0;
  else if ( _tuplet->base()==0 ) return 0;
  else return _tuplet;
}


void Note::setPitch(int p) { _pitch = p; }

void Note::setVel(int v) { _vel=v; if (_vel>127) _vel = 127; if (_vel<1) _vel = 1; }

void Note::setEnh(int e) { _prop -= _prop & MASK_ENH; _prop += (e & MASK_ENH) + 2; }

void Note::setChan(int c) { _chan=c; }

void Note::setStem(int s) { _prop -= _prop & MASK_STEM; _prop += (s << SHIFT_STEM) & MASK_STEM; }

void Note::setNogroup(bool ng) { _prop -= _prop & MASK_NOGROUP; _prop += (ng << SHIFT_NOGROUP) & MASK_NOGROUP; }

void Note::setTuplet(Tuplet * tp) { _tuplet = tp; }



int Note::tupletBase() const {
  if (_tuplet!=0) return _tuplet->base();
  else return 0;
}

int Note::tupletDuration() const {
  if (_tuplet!=0) return _tuplet->duration();
  else return 0;
}

void Note::tuplet(int base, int duration) {
  if (_tuplet) {
    _tuplet->setBase(base);
    _tuplet->setDuration(duration);
  } else {
    _tuplet = new Tuplet(base,duration);
  }
}

long Note::display(int res) const {
  long disp = duration();
  if (_tuplet != 0) disp = _tuplet->display(disp);

  if (res>1) {
    disp += int(res*0.49);
    disp -= (disp%res);
  }
  return disp;
}

void Note::add(Ornament * o) {
  _ornament->add(o);
}

void Note::remove(Ornament * o) {
  // no delete ornament here, this is done in AddOrnament's destructor
  _ornament->remove(o);
}

Expression * Note::setExpression(int exp) {
  Expression * ne = 0;
  for (Element * el = _ornament->content(); el != 0; el = Element::next(el)) {
    if (el->isA() == EXPRESSION) if (((Expression*)el)->expression()==exp) ne = (Expression*) el;
  }
  if (ne==0) {
    ne = new Expression(exp);
    sonG->doo(new AddOrnament(ne, this));
  }
  return ne;
}

Bow * Note::setBow(int len, int dir, int delta) {
  Bow * nb = 0;
  for (Element * el = _ornament->content(); el != 0; el = Element::next(el)) {
    if (el->isA() == BOW) nb = (Bow*) el;
  }
  if (nb==0) {
    nb = new Bow(len,dir,delta);
    sonG->doo(new AddOrnament(nb, this));
  }
  return nb;
}

Vector * Note::removeExp() {
  Vector * ret = new Vector();
  for (int i=0; i<_ornament->size(); ) {
    Element * el = _ornament->get(i);
    if (el->isA() == EXPRESSION) { _ornament->remove(el); ret->add(el); }
    else i++;
  }
  return ret;
}

Vector * Note::removeBow() {
  Vector * ret = new Vector();
  for (int i=0; i<_ornament->size(); ) {
    Element * el = _ornament->get(i);
    if (el->isA() == BOW) { _ornament->remove(el); ret->add(el); }
    else i++;
  }
  return ret;
}

Lyrics * Note::lyrics() {
  Lyrics * rv = 0;
  for (Element * el = _ornament->content(); el != 0; el = Element::next(el)) {
    if (el->isA() == LYRICS) rv = (Lyrics*) el;
  }
  return rv;
}

RiemannFunction * Note::function() {
  RiemannFunction * rv = 0;
  for (Element * el = _ornament->content(); el != 0; el = Element::next(el)) {
    if (el->isA() == RIEMANNFUNCTION) rv = (RiemannFunction*) el;
  }
  return rv;
}


// TODO: calculate enh into this:

char * Note::cPitch() {
  int n = _pitch%12;
  char ff = 0;
  char sg = 0;
  switch (n) {
  case 0: ff = 'c'; sg =' '; break;
  case 1: ff = 'c'; sg ='#'; break;
  case 2: ff = 'd'; sg =' '; break;
  case 3: ff = 'd'; sg ='#'; break;
  case 4: ff = 'e'; sg =' '; break;
  case 5: ff = 'f'; sg =' '; break;
  case 6: ff = 'f'; sg ='#'; break;
  case 7: ff = 'g'; sg =' '; break;
  case 8: ff = 'g'; sg ='#'; break;
  case 9: ff = 'a'; sg =' '; break;
  case 10: ff = 'a'; sg ='#'; break;
  case 11: ff = 'h'; sg =' '; break;
  }
  if (sg==' ')
    sprintf(_cPitch,"%c%d ",ff,(int)_pitch/12-2);
  else
    sprintf(_cPitch,"%c%c%d",ff,sg,(int)_pitch/12-2);
  return _cPitch;
}



ostream & Note::print(int dep, ostream & s) const {
  int ehs = enh();
  int stm = stem();
  int tup1 = tupletBase();
  int tup2 = tupletDuration();
  bool nogrp = nogroup();

  s << spc(dep) << "<NOTE pos=\"" << internalStart().ticks() << "\" len=\"" << duration() << "\" pitch=\"" << _pitch << "\" vel=\"" << _vel << "\"";
  if (ehs != 0) s << " enh=\"" << ehs << "\"";
  if (stm != 0) s << " stem=\"" << stm << "\"";
  if (tup1 != 0) s << " tuplet-base=\"" << tup1 << "\" tuplet-duration=\"" << tup2 << "\"";
  if (nogrp)  s << " nogroup=\"true\"";
  if (_chan != -1) s << " chan=\"" << _chan << "\"";
  s << " >" << endl;
  for (Element * el = _ornament->content(); el != 0; el = Element::next(el)) {
    el->print(dep+1,s);
  }
  s << spc(dep) << "</NOTE>" << endl;
  return s;
}

void Note::flush(const char * c) const {
  cout << c << "NOTE at " << internalStart().bar() << "." << internalStart().beat() << "." << internalStart().tick() << endl;
}

Element * Note::copy() const {
  return new Note(*this);
}



Element * Note::load(char * aline, ifstream *& inPtr, Element * ) { // parent
  Note * note = new Note();
  Table * attr = Loader::getAttributes("NOTE",aline);
  if (attr!=0) {

    int pitch = 0;
    int vel = 0;
    long llen = 0;
    long pos = 0;
    int enh = 0;
    int stm = 0;
    int tup1 = 0;
    int tup2 = 0;
    bool nogrp = false;
    int chan = -1;

    String * val = 0;

    if ((val = (String*) attr->getEntry("pitch")) != 0) pitch = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("vel")) != 0) vel = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("len")) != 0) llen = atol(val->getValue());
    if ((val = (String*) attr->getEntry("pos")) != 0) pos = atol(val->getValue());
    if ((val = (String*) attr->getEntry("enh")) != 0) enh = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("stem")) != 0) stm = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("tuplet-base")) != 0) tup1 = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("tuplet-duration")) != 0) tup2 = atoi(val->getValue());
    if ((val = (String*) attr->getEntry("nogroup")) != 0) nogrp = strcmp(val->getValue(),"true") ? true : false;
    if ((val = (String*) attr->getEntry("chan")) != 0) chan = atoi(val->getValue());

    note->setPitch(pitch);
    note->setVel(vel);
    note->setDuration(llen);
    note->setInternalStart(pos);
    note->setEnh(enh);
    note->setStem(stm);
    if (tup1!=0) { note->tuplet(tup1,tup2); }
    note->setNogroup(nogrp);
    note->setChan(chan);

    const char * orns[] = { "LYRICS", "EXP", "BOW" };
    Element*(*funPtr[])(char*,ifstream*&,Element*) = { &Lyrics::load, &Expression::load, &Bow::load };
    // Element::loadContent(note->ornament(),"/NOTE","EXP",&Expression::load,inPtr);

    Element::loadContent(note->ornament(),"/NOTE", 3, orns, funPtr, inPtr);

    attr->scratch();
    delete attr;
  }
  return note;
}


#endif
