#ifndef _SCOREBAR_H_
#define _SCOREBAR_H_

#include "scoreObject.h"
#include "position.h"
#include "table.h"

class ScoreGroup;
class Part;
class Note;
class Event;
class Symbol;
class Reference;

enum ScoreType { SINGLESCORE, MULTIPLESCORE };

class ScoreBar : public ScoreObject
{
 private:
  ScoreType _score_type;
  bool      _is_first;
  int       _key;
  int       _clef;
  int       _meter0;
  int       _meter1;
  int       _program;
  int       _shortest;
  double    _scale;
  int       _common_indent;
  int       _common_raw_width;
  bool      _active;
  Table     _groups;
  Table     _symbols;
  struct BarInitState * state;

 public:
  /** a part is specified only if this is the first bar inside the part
   */
  ScoreBar(ScoreType scoretype, Part * part, bool isfirst=false, bool isActive=false);
  ~ScoreBar();

  void add(Event*, Position, long, int, bool, bool);

  bool isFirst() const { return _is_first; }
  bool isLast() { return (_groups.next(this)==0); }
  bool isActive() const { return _active; }
  int key() const { return _key; }
  int clef() const { return _clef; }
  int meter(int i) const { return (i==0?_meter0:_meter1); }
  void setMeter(int,int);
  int program() const { return _program; }
  double scale() const { return _scale; }
  void setScale(double);
  void setRawWidth(int);
  const char * position();

  bool multiple() const { return (_score_type == MULTIPLESCORE); }

  /** Returns the number of units (chars in text-presentation, pixels in graphical presentation) used for the key and signature for this bar.
   * This is usually zero except for the first bar inside a part
   */
  int systemIndent();

  void setIndent(int);

  int commonIndent() const { return _common_indent; }

  int commonRawWidth() const { return _common_raw_width; }

    /** Returns the smallest width for this bar. It is determined by  wd =  8 units * 1536 ticks / length_of_shortest_note_in_bar
   * e.g. when the shortest note within the bar is an eigth (192 ticks), the returned value is 64 units
   */
  int rawWidth() const { return int(8*1536.0/_shortest); }

  /** Returns the total width including scaling and indent!
   */
  int width();

  int xindent();

  /** Returns the number of units (chars in text-presentation, pixels in graphical presentation) used to propagate one tick. This is a ratio!
   */
  double unitsPerTick();

  Reference * symbols();

  virtual const Position & start() const;
  virtual long end() const;
  virtual long duration() const;
  virtual int display() const;
  virtual void paint(PrScoreEditor * ed, int x=0, int y=0, int style=0);
  virtual void print(PrScoreEditor * ed, int x=0, int y=0);

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

};

#endif
