#ifndef _SCOREGROUP_CPP_
#define _SCOREGROUP_CPP_

#include <iostream.h>

#include "scoreGroup.h"
#include "scoreChord.h"
#include "scoreBreak.h"
#include "note.h"
#include "part.h"
#include "prScorePainter.h"
#include "prScoreEditor.h"
#include "prFactory.h"
#include "scorePrinter.h"

extern PrFactory * factory;

struct GroupInitState {
  Position cur_pos;
  ScoreElement * element;
};


ScoreGroup::ScoreGroup() : _tuplet(0), _chords(0) {
  state = new GroupInitState;
  state->cur_pos  = 0;
  state->element  = 0;
}

ScoreGroup::~ScoreGroup() {
  delete state;
}


void ScoreGroup::create(Note * note, long dur, int dis) {
  if (note) {
    state->element = new ScoreChord();
    if (note) {
      if (dis < 384) _chords++;
    }
  } else {
    state->element = new ScoreBreak();
  }
  _elements.add(state->element);
}



void ScoreGroup::add(Note * note, Position pos, long dur, int dis, bool _no_overlap) {
  if (note && note->tupletBase() != 0) _tuplet = note->tupletBase();
  if (!state->element) {
    create(note, dur, dis);
    // cout << "at " << pos << " add note " << note << ", len: " << len << endl;
    state->element->add(note, pos, dur, dis, _no_overlap);
    state->cur_pos = pos;
  } else {
    if (pos < state->cur_pos) {
      cout << "ScoreGroup::PANIC" << endl; // TODO: wech!
    } else if (pos == state->cur_pos) {
      // cout << "at " << pos << " add note " << note << ", len: " << len << endl;
      state->element->add(note, pos, dur, dis, _no_overlap);
    } else {
      state->element = 0;
      add(note,pos,dur,dis,_no_overlap);
    }
  }
}

ostream & ScoreGroup::print(int dep, ostream & s) const {
  s << spc(dep) << "<SCOREGROUP start=\"" << start() << "\" duration=\"" << duration() << "\" >" << endl;
  for (int i=0; i<_elements.size(); i++)
    _elements.get(i)->print(dep+1,s);
  s << spc(dep) << "</SCOREGROUP>" << endl;
  return s;
}

void ScoreGroup::flush(const char * c) const {
  cout << c << "SCOREGROUP" << endl;
}

Element * ScoreGroup::copy() const {
  return new ScoreGroup();
}





const Position & ScoreGroup::start() const {
  if (_elements.first() != 0) return ((ScoreElement*) _elements.first())->start();
  else return *(new Position(0));
}

long ScoreGroup::end() const {
  long x = start().ticks();
  x += duration();
  return x;
}

long ScoreGroup::duration() const {
  if (_elements.first() != 0)
    return ( ((ScoreElement*) _elements.last())->end() - ((ScoreElement*) _elements.first())->start().ticks() );
  else return 0;
}

int ScoreGroup::display() const {
  if (_elements.first() != 0)
    return ( ((ScoreElement*) _elements.last())->end() - ((ScoreElement*) _elements.first())->start().ticks() );
  else return 0;
}

void ScoreGroup::paint(PrScoreEditor * ed, int x, int y, int) {
  factory->getScorePainter()->paintGroup(this, ed, &_elements, x, y);
}

void ScoreGroup::print(PrScoreEditor * ed, int x, int y) {
  factory->getScorePrinter()->paintGroup(this, ed, &_elements, x, y);
}


#endif
