#ifndef _SELECTIONITERATOR_CPP_
#define _SELECTIONITERATOR_CPP_

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "selectionIterator.h"
#include "table.h"
#include "reference.h"
#include "part.h"
#include "event.h"
#include "note.h"
#include "prPartEditor.h"

extern Table * selectioN;
extern Table * selectionMemory;


SelectionIterator::SelectionIterator(const SelectionIterator & i) : _table(i._table), _ref(i._ref), _event(i._event) { }

SelectionIterator::SelectionIterator(Table * table) : _table(table), _ref(0), _event(0) {
  if (!_table) _table = selectioN;
  if (_table) {
    _ref = (Reference*) _table->first();
    if (_ref) _event = (Event*) _ref->getValue();
  }
}


bool SelectionIterator::operator!=(const SelectionIterator& i) const {
  return (_table != i._table) || (_event != i._event);
}

bool SelectionIterator::operator==(const SelectionIterator& i) const {
  return (_table == i._table) && (_event == i._event);
}

bool SelectionIterator::done() { return (_event==0); }

Element * SelectionIterator::operator *() {
  return _event;
}

SelectionIterator & SelectionIterator::operator++() {
  if(!_ref || !_table) {
    cerr << ("NO EVENT OR NO TABLE\n");
    return *this;
  }
  _ref = (Reference*) _table->next(_ref);
  if (_ref) {
    _event = (Event*) _ref->getValue();
  } else {
    _event = 0;
  }
  return *this;
}

SelectionIterator SelectionIterator::operator++(int) {
  SelectionIterator __tmp = *this;
  ++*this;
  return __tmp;
}

Position SelectionIterator::start() {
  return _event->internalStart();
}



#endif
