#ifndef _PART_CPP_
#define _PART_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "part.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "track.h"
#include "event.h"
#include "note.h"
#include "song.h"
#include "reference.h"
#include "event.h"
#include "prFactory.h"
#include "prPart.h"
#include "element.h"
#include "symbol.h"
#include "addSymbol.h"

extern Song * sonG;
extern PrFactory * factory;

extern char * getcmd(char*);

void swap(int & a, int & b) {
  int foo = a;
  a = b;
  b = foo;
}

void swap(long & a, long & b) {
  long foo = a;
  a = b;
  b = foo;
}

Part::Part() : _pos(0), _key(0), _clef(0), _meter0(4), _meter1(4), _program(0), _track(0), _mem(new Table()), _memref(0) {
  _type = PART;
  _cur[0] = 0;
  _cur[1] = 0;
  _pr = factory->createPart(this);
}

Part::Part(Part * e) : Compound(e,PART), _mem(new Table()), _memref(0) {
  if (e) {
    _pos = e->start();
    _key = e->key();
    _clef = e->clef();
    _meter0 = e->meter0();
    _meter1 = e->meter1();
    _program = e->program();
    _cur[0] = e->current(0);
    _cur[1] = e->current(1);
    _track = e->track();
    _pr = factory->createPart(this);
  }
}

Part::Part(Track * tr) : _pos(0), _key(0), _clef(0), _meter0(4), _meter1(4), _program(0), _track(tr), _mem(new Table()), _memref(0) {
  _type = PART;
  _cur[0] = 0;
  _cur[1] = 0;
  _pr = factory->createPart(this);
}


Part::~Part() {
  delete _mem;
  if (_pr!=0) _pr->erase();
}

Position Part::start() { return _pos; }

int Part::key() { return _key; }

int Part::clef() { return _clef; }

int Part::meter0() { return _meter0; }

int Part::meter1() { return _meter1; }

int Part::program() { return _program; }

Track * Part::track() { return _track; }


void Part::setStart(Position pos) { _pos = pos; reorder(); }

void Part::setKey(int k) { _key = k; }

void Part::setClef(int c) { _clef = c; }

void Part::setMeter(int m0, int m1) { setMeter0(m0); setMeter1(m1); }

void Part::setMeter0(int m0) { _meter0 = m0; }

void Part::setMeter1(int m1) { _meter1 = m1; }

void Part::setProgram(int p) { _program = p; }

void Part::setTrack(Track * tr) { _track = tr; }


void Part::rewind(int num) { _cur[num] = (Event*) content(); }

bool Part::wind(Position p, int num) {
  int found = 0;
  for ( _cur[num] = (Event*) content(); found==0; ) {
    if (_cur[num]!=0) {
      if ( currentStartsBehind(p.ticks(), num) ) {
	found = 1;
      } else if ( currentStartsAt(p.ticks(), num) ) {
	found = 1;
      } else {
	_cur[num] = (Event*) next(_cur[num]);
      }
    } else {
      found = -1;
    }
  }
  return (found==1);
}

bool Part::current(Type t, int num) { return (_cur[num]!=0?(_cur[num]->isA()==t):false); }

bool Part::currentStartsBefore(long l, int num) {
  bool ok = true;
  if (_cur[num]==0) { ok = false; }
  else {
    // cout << "cmp " << _cur[num]->start().ticks() << " with " << l-_pos.ticks() << endl;
    ok = (_cur[num]->startsBefore(l-_pos.ticks()));
  }
  return ok;
}

bool Part::currentStartsBehind(long l, int num) {
  bool ok = true;
  if (_cur[num]==0) { ok = false; }
  else {
    // cout << "cmp " << _cur[num]->start().ticks() << " with " << l-_pos.ticks() << endl;
    ok = (_cur[num]->startsBehind(l-_pos.ticks()));
  }
  return ok;
}

bool Part::currentStartsAt(long l, int num) {
  bool ok = true;
  if (_cur[num]==0) { ok = false; }
  else {
    // cout << "cmp " << _cur[num]->start().ticks() << " with " << l-_pos.ticks() << "(" << l << "-" << _pos.ticks() << ")" << endl;
    ok = (_cur[num]->startsAt(l-_pos.ticks()));
  }
  // cout << "Part::currentStartsAt returns " << ok << endl;
  return ok;
}

bool Part::currentEndsBehind(long l, int num) {
  bool ok = true;
  if (_cur[num]==0) { ok = false; }
  else {
    // cout << "cmp " << _cur[num]->start().ticks() << " with " << l-_pos.ticks() << endl;
    ok = (_cur[num]->endsBehind(l-_pos.ticks()));
  }
  return ok;
}

long Part::currentPos(int num) { return _cur[num]->start().ticks() + _pos.ticks(); }

Event * Part::current(int num) { return _cur[num]; }

bool Part::currentInc(int num) {
  bool ok = true;
  Event * e = (Event*) next(_cur[num]);
  // if (e!=0) _cur[num] = e;
  // else ok = false;
  _cur[num] = e;
  if (e==0) ok = false;
  return ok;
}


void Part::rememberCurrent(int num) {
  _mem->add(new Reference(_cur[num]));
}


void Part::startMem() { _memref = (Reference*) _mem->content(); }

// bool Part::moreMem() { return (next(_memref)!=0); }
bool Part::moreMem() { return (_memref!=0); }

void Part::incMem() { _memref = (Reference*) next(_memref); }

void Part::cutMem() {
  Reference * foo = (Reference*) next(_memref);
  _mem->remove(_memref);
  delete _memref;
  _memref = foo;
}

void Part::clearMem() {
  delete _mem; // deletes the references, not their values! (scratch would delete their values!)
  _mem = new Table();
}

bool Part::memEndsAt(long p) {
  // cout << " * " << ((Event*)_memref->getValue())->end() << " ends at " << p << " - " << _pos.ticks() << " ?" << endl; 
  return (((Event*)_memref->getValue())->endsAt(p - _pos.ticks()));
}

Event * Part::mem() {
  return (Event*) _memref->getValue();
}


void Part::flushCurrent() {
  if (_cur[0]) {
    Position p = start()+_cur[0]->start().ticks();
    int bar = 0;
    int beat = 0;
    int tick = 0;
    char * cpos = new char[13];
    sonG->bbt(bar,beat,tick,p);
    sprintf(cpos,"%3d.%2d.%3d",bar,beat,tick);
    cout << _cur[0]->ctype() << " at " << cpos << "  ";
    if (_cur[0]->isA()==NOTE) {
      cout << ((Note*)_cur[0])->cPitch() << "  " << _cur[0]->length() << "  " << ((Note*)_cur[0])->vel();
    }
    cout << endl;
    delete cpos;
  }
}

PrPart * Part::presentation() { return _pr; }


Reference * Part::makeRefs(int p1, int p2, long left, long right) {
  Reference * ret = 0;
  Note * n = 0;
  bool add = false;
  if (p1 > p2) swap(p1,p2);
  if (left > right) swap(left,right);
  for (Event * e = (Event*) content(); e != 0; e = (Event*) next(e)) {
    add = false;
    if ((e->start().ticks() >= left) && (e->end() <= right)) {
      if (e->isA()==NOTE) {
	n = (Note*) e;
	if ((n->pitch()>=p1) && (n->pitch()<=p2)) add = true;
      } else {
	add = true;
      }
    }
    if (add) {
      if (ret==0) ret = new Reference(e);
      else        Element::append(new Reference(e),ret);
    }
  }
  return ret;
}

void Part::reorder() {
  // cout << "TODO: reorder parts" << endl;
  
  bool exit = false;
  Part * succ = 0;
  while (!exit) {
    exit = true;
    for (Part * pt = (Part*) _track->first(); (pt!=0) && exit; pt = (Part*) _track->next(pt)) {
      // cout << "loop: " << _track->first() << ", " << pt << ", " << pt->start().ticks() << " - ";
      succ = (Part*) _track->next(pt);
      // if (succ!=0) cout << succ << ", " << succ->start().ticks();
      // cout << endl;
      if (succ!=0)
	if (succ->start() < pt->start()) {
	  //cout << "repl. ";
	  _track->replace(pt,succ);
	  // cout << "ok " << endl;
	  // cout << "  : " << _track->first() << ", " << pt << ", " << pt->start().ticks() << " - ";
	  // if (_track->next(pt)!=0) cout << _track->next(pt) << ", " << ((Part*) _track->next(pt))->start().ticks();
	  // cout << endl;
	  exit = false;
	}
    }
  }
}

void Part::partCopy() {

}

Part * Part::partGlue() {
  Part * pt2 = (Part*) next(this);
  if (pt2 != 0) {
    Event * glue1 = (Event*) last();
    Event * glue2 = (Event*) pt2->first();
    if ((glue1!=0) && (glue2!=0)) {
      long offset = pt2->start() - start().ticks();
      for (Event * ev = glue2; ev != 0; ev = (Event*) next(ev))
	ev->setStart(ev->start() + offset);
      // ((Compound*)this)->add(glue2);
      Compound::add(glue2);
      pt2->setContent(0);
      pt2->track()->remove(pt2);
      // never delete: may cause trouble with movePart->undo(), instead it is hidden within operation: delete pt2;
    }
  }
  return pt2;
}

Event * Part::partSplit(Position p) { // the position p is relative to the start position of the part
  Event * ev = 0;
  for (Event * a = (Event*) first(); (a!=0) && (ev==0); a = (Event*) next(a)) {
    if (a->start() >= p) ev = a;
  }
  if (ev!=0) {
    if ((prev(ev)==0) || (next(ev)==0)) ev = 0; // no split if split is at beginning or end
    else {
      splitBefore(ev);
    }
  }
  return ev;
}



void Part::add(Element * el) {
  if (el!=0) {
    if (content()==0) {
      setContent(el);
    } else {
      Event * ev = 0;
      // Event * succ = 0;
      long pos = 0;
      int pitch = 0;
      long newpos = ((Event*)el)->start().ticks();
      int newpitch = 0;
      bool done = false;
      // long deltapos = 0; // diff in position of the current event compared to the following event.
      if (el->isA()==NOTE) newpitch = ((Note*)el)->pitch(); else newpitch = 0;
      for (Element * cur = first(); ((cur != 0) && (!done)); cur = Element::next(cur)) {
	ev  = (Event*) cur;
	pos = ev->start().ticks();
	if (cur->isA()==NOTE) pitch = ((Note*)cur)->pitch(); else pitch = 0;
	if (pos > newpos) {
	  insertBefore(el,cur);
	  done = true;
	} else if (pos==newpos) {
	  // succ = (Event*) Element::next(cur);
	  // if (succ != 0) deltapos = succ->start()-pos; else deltapos = 0;
	  if (pitch >= newpitch) {
	    insertBefore(el,cur);
	    done = true;
	  }
	}
      }
      if (!done) { Element::append(el,content()); }
    }
  }
}

void Part::hide() {
  if (_pr!=0) _pr->hide();
}

void Part::show() {
  if (_pr!=0) _pr->show();
}


ostream & Part::print(int dep, ostream & s) {
  s << spc(dep) << "<PART offset=\"" << _pos.ticks() << "\" >" << endl;
  s << spc(dep) << "<OPTIONS clef=\"" << _clef << "\"";
  s << " meter0=\"" << _meter0 << "\"";
  s << " meter1=\"" << _meter1 << "\"";
  s << " key=\"" << _key << "\"";
  s << " program=\"" << _program << "\"";
  s << " />" << endl;
  printContent(dep,s);
  s << spc(dep) << "</PART>" << endl;
  return s;
}

void Part::flush(char* c) {
  cout << c << "PART" << endl;
}

Element * Part::copy() {
  Part * sng = new Part(this);
  return sng;
}

Element * Part::load(char * aline, ifstream *& inPtr, Element * parent) {
  Part * part = 0;
  Table * attr = Loader::getAttributes("PART",aline);
  if ((attr!=0) && (attr->getEntry("offset"))) {
    part = new Part((Track*)parent);
    part->setStart(Position(atol(((String*) attr->getEntry("offset"))->getValue())));
    Table * opt = Loader::getAttributes("OPTIONS",inPtr);
    int clef = 0;
    int meter0 = 0;
    int meter1 = 0;
    int key = 0;
    int program = 0;
    if (opt->getEntry("clef")) clef = atoi(((String*) opt->getEntry("clef"))->getValue());
    if (opt->getEntry("meter0")) meter0 = atoi(((String*) opt->getEntry("meter0"))->getValue());
    if (opt->getEntry("meter1")) meter1 = atoi(((String*) opt->getEntry("meter1"))->getValue());
    if (opt->getEntry("key")) key = atoi(((String*) opt->getEntry("key"))->getValue());
    if (opt->getEntry("program")) program = atoi(((String*) opt->getEntry("program"))->getValue());
    
    part->setClef(clef);
    part->setMeter0(meter0);
    part->setMeter1(meter1);
    part->setKey(key);
    part->setProgram(program);

    Element::loadContent(part,"/PART","NOTE",&Note::load,inPtr);

    attr->scratch();
    delete attr;
    opt->scratch();
    delete opt;
  }
  return part;
}

Symbol * Part::setSymbol(Position p, int sym, int off, int par) {
  Symbol * nae = 0;

  for (Event * a = (Event*) first(); a!=0; a = (Event*) next(a)) {
    if ((a->isA()==SYMBOL) && (a->start()==p)) {
      if  (((Symbol*)a)->symbol()==sym) nae = (Symbol*) a;
    }
  }
  if (nae==0) {
    if (par==-2)      { char * txt = new char[1]; txt[0] = 0; nae = new Symbol(p,txt,off); } // text
    else if (par==-1) nae = new Symbol(p,sym,off); // symbol
    else              nae = new Symbol(p,sym,off,par); // parameterized symbol
    // addAtom(nae);
    sonG->doo(new AddSymbol(nae,this));
  }
  return nae;
}


//
// player functions:
//

bool Part::rewindPlayer() { return rewind(1); }

bool Part::windPlayer(Position p) { return wind(p, 1); }

bool Part::currentPlayer(Type t) { return current(t, 1); }

Event * Part::currentPlayer() { return current(1); }

/* This works in the following manner: the currentInc method increments the internal pointer and returns true, if more events
 * exist. If this is the case, we return this part to indicate, playing continues within this part. If currentInc returns
 * false, we know we've reached the end of this part and we have to check whether another part follows. If no part follows,
 * we return zero to indicate we're done, if a part does follow, we return that part, but caution: We have to transfer the
 * _mem and _memref to that part to make sure the opened tunes are being closed again!
 */
Part * Part::currentPlayerInc() {
  Part * ret;
  bool ok = currentInc(1);
  if (ok) ret = this; // more events to follow!
  else {
    ret = (Part*) next(this);
    if (ret!=0) { // transfer mem to next part
      ret->rewindPlayer();
      cout << "size: " << ret->_mem->size() << endl;
      ret->_mem = _mem;
      ret->_memref = _memref;
      long diff = start().ticks() - ret->start().ticks();
      for (int i = 0; i<ret->_mem->size(); i++) {
	Event * ev = ((Event*) ((Reference*)ret->_mem->get(i))->getValue());
	cout << "start: " << ev->start() << " -> ";
	ev->setStart(ev->start() + diff);
	cout << ev->start() << endl;
      }
      _mem = new Table();
      _memref = 0;
    }
  }
  return ret;
}

bool Part::currentPlayerStartsAt(long p) { return currentStartsAt(p, 1); }

bool Part::currentPlayerStartsBehind(long p) { return currentStartsBehind(p, 1); }

void Part::rememberCurrentPlayer() { return rememberCurrent(1); }


#endif
