#ifndef _MAIN_CPP_
#define _MAIN_CPP_

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ltdl.h"

#include "addElement.h"
#include "element.h"
#include "song.h"
#include "track.h"
#include "part.h"
#include "prFactory.h"
#include "vector.h"
#include "note.h"
#include "prMainEditor.h"
#include "reference.h"
#include "scoreTrack.h"
#include "str.h"
#include "table.h"
#include "player.h"
#include "version.h"

typedef PrFactory * (*FactoryFunction)();

extern PrFactory * factory;
extern PrMainEditor * mainEditor;

extern int output;

extern char * parameter(const char * name, const char * alt, int argc, char ** argv);


void main(int argc, char ** argv) {
  

  if (argc>1 && (strcmp(argv[1],"--help")==0 || strcmp(argv[1],"-h")==0)) {
    cout << "usage: " << argv[0] << " [options]* [filename]" << endl;
    cout << endl << "options are:" << endl;
    cout << "   -a, --addon <MODULENAME>: Loads the specified module" << endl;
    cout << "   -h, --help:               Displays this message" << endl;
    cout << "   -p, --presentation <LIB>, where <LIB> is one of \"text\", \"kde\" (default), or the libraryname" << endl;
    cout << "   -v, --version:            Displays the version number" << endl;
    cout << endl;
  } else if (argc>1 && (strcmp(argv[1],"--version")==0 || strcmp(argv[1],"-v")==0)) {
    cout << argv[0] << " " << BRAHMS_VERSION << endl;
  } else {
  
  const char * DLERROR;
  char * presentation = parameter("--presentation", "-p",argc,argv);

  char * out = parameter("--output", "-o",argc,argv);
  output = 1;
  if (out>0) {
    if (strcmp(out,"kmid")==0) output = KMID;
    if (strcmp(out,"arts")==0) output = ARTS;
    if (strcmp(out,"alsa")==0) output = ALSA;
  }

  if (presentation==NULL) {
    presentation = strdup("kde");
    //cout << "usage: " << argv[0] << " [-p|--presentation text|kde|<LIBRARY-NAME>] [-a|--addon <MODULENAME>]* [-f|--file <BRAHMS-FILE>]" << endl;
    //cout << "or: " << argv[0] << " [-h|--help]" << endl;
    //exit(1);
  }

  // rename shortcuts
  if (strcmp(presentation,"text")==0) { presentation = strdup("libBrahmsTextPresentation"); }
  else if (strcmp(presentation,"kde")==0) { presentation = strdup("libBrahmsKdePresentation"); }
  else if (strcmp(presentation,"qt")==0) { presentation = strdup("libBrahmsQtPresentation"); }
  
  int plen = strlen(presentation);
  char * fname = new char[plen+4];
  sprintf(fname,"%s.la",presentation);

  lt_dlinit();
  lt_dladdsearchdir(PLUGIN_DIR);




#ifdef DEBUGIT
  cout << "trying to open library " << fname << " ..." << endl;
#endif
  lt_dlhandle handle = lt_dlopen (fname);
  if (!handle) {
    cout << "error open presentation: " << lt_dlerror() << endl;
    exit(1);
  }
  
#ifdef DEBUGIT
  cout << "trying to get symbol " << presentation << " ..." << endl;
#endif
  FactoryFunction getFactory = (FactoryFunction) lt_dlsym(handle,presentation);
  if ((DLERROR = lt_dlerror()) != NULL)  {
    cout << "error sym: " << DLERROR << endl;
    exit(1);
  }
  factory = getFactory();
  
#ifdef DEBUGIT
  cout << factory->isA() << endl;
#endif

  mainEditor = factory->createMainEditor(argc,argv);
    
  mainEditor->run();
  mainEditor->closeEditors();
  delete mainEditor;
  delete factory;
  lt_dlclose(handle);

  lt_dlexit(); 
  }
}


#endif
