#ifndef _KDEAUDIOCONTENT_CPP_
#define _KDEAUDIOCONTENT_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include <qsplitter.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qframe.h>
#include <qpainter.h>
#include <qlineedit.h>
#include "kdeCursor.h"
#include <klocale.h>
#include <kiconloader.h>

#include "part.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "audioEvent.h"
#include "position.h"
#include "addElement.h"
#include "iterator.h"
#include "audioTrack.h"
#include "addElement.h"
#include "removeElement.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "newSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "table.h"
#include "reference.h"
#include "scoreTrack.h"
#include "player.h"
#include "iterator.h"

#include "kdeAudioContent.h"
#include "kdeAudioEditor.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorMenuBar.h"
#include "brahmsResources.h"
#include "positionCursor.h"
#include "kdeMainEditor.h"

#define ME ((KdeMainEditor*)mainEditor)

extern Song * sonG;
extern PrMainEditor * mainEditor;
extern Table * selectioN;


KdeAudioContent::KdeAudioContent(KdeAudioEditor * ed , KdeEditorToolBar * tb)
  : QFrame((QWidget*) ed, "content", QFrame::Sunken), _editor(ed), _toolbar(tb),
    _grabX(-1), _xoffset(24), _yoffset(20), _height(16), _grab(0), _edit(0), _line_event(0), shftFlag(false), ctrlFlag(false), suprFlag(false)
{

  KIconLoader * loader = KGlobal::iconLoader();
  QPixmap qp = loader->loadIcon( "backWood",KIcon::Toolbar );
  setBackgroundPixmap(qp);

  // setBackgroundMode(QWidget::PaletteMidlight);
  moveWidget = new QFrame(this,"move");
  ((QFrame*)moveWidget)->setFrameStyle( QFrame::Panel | QFrame::Raised );
  moveWidget->setBackgroundMode(QWidget::PaletteBackground);
  moveWidget->hide();

  _position_cursor = new PositionCursor(this,_xoffset);

  _line = new QLineEdit(this);
  _line->hide();
  connect(_line, SIGNAL(returnPressed()), SLOT(updateLine()));


  rbmenu = new QPopupMenu();
  rbmenu->connectItem( rbmenu->insertItem(i18n("edit file")), this, SLOT(editFile()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("edit filename")), this, SLOT(editFileName()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("delete audioevent")), this, SLOT(deleteAudioEvent()) );


  //
  // Contents:
  // =========


  // setCentralWidget(_splitter);


  update();
  sonG->updateGui();
  setFocus();
}


void KdeAudioContent::editFile() {
  if (_edit!=0) {
    const char * fname = ((AudioEvent*)_edit)->fileName();
    if (fname && strlen(fname)>0) {
      char * command = new char[strlen(fname)+30];
      sprintf(command,"kwave %s &", fname);
      int e = ::system(command);
      if (e!=0) ME->slotStatusHelpMsg(i18n("An error has occured using kwave"));
      delete command;
    }
  }
}

void KdeAudioContent::editFileName() {
  if (_edit!=0 && !_line->isVisible()) {
    _line->setGeometry(_moveX-2, mouseY()-1, 120, _height+2);
    _line->show();
    _line_event = _edit;
    _line->setText(((AudioEvent*)_line_event)->fileName());
    _line->setFocus();
    _line->selectAll();
    _edit = 0;
  }
}

void KdeAudioContent::updateLine() {
  if (_line_event) {
    ((AudioEvent*)_line_event)->setFileName(strdup(_line->text()));
    repaint(FALSE);
    _line_event = 0;
    _line->hide();
    _edit = 0;
  }
}

void KdeAudioContent::deleteAudioEvent() {
  if (_edit!=0) {
    sonG->doo(new RemoveElement(_edit, _editor->part()));
    _edit = 0;
    repaint(FALSE);
  }
}


void KdeAudioContent::keyPressEvent ( QKeyEvent * key ) {
  // _content->keyPressEvent(key);
}

void KdeAudioContent::keyReleaseEvent ( QKeyEvent * key ) {
  // _content->keyReleaseEvent(key);
}

// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void KdeAudioContent::paintEvent( QPaintEvent * ) {

  setMouseTracking(TRUE);

  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter painter;
  painter.begin( &pix );
  AudioEvent * ae = 0;

  _xright = width()-24;
  int _ybottom = height()-48;
  double pixPerTick = (_xright-_xoffset)*1.0/(_editor->right().ticks() - _editor->left().ticks());
  int yy = 0;



    //
    // vertical lines
    //
    long xx;
    int xLeft = -1;
    int xRight = -1;
    int beat;
    int bar;
    int tick;
    Position pos = 0;
    Position add = Position(1,2,0); // one beat!
    char * txt = new char[12];
    bool draw = true;
    bool showNum;


    while (draw) {
      xx = pos.ticks();
      xx = int(xx*pixPerTick + _xoffset);
      if (xLeft==-1) xLeft = xx;
      pos.gBBT(bar,beat,tick);

      if (beat==1) {
	sprintf(txt,"%d",bar+_editor->left().bar()-1);
	showNum = false;
	if (pixPerTick>0.015625) showNum = true;
	else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
	else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
	else if ((bar&127)==1) showNum = true;
	if (showNum) painter.drawText(xx+1, _yoffset-2, txt);
	if ((bar&7)==1) { painter.setPen(SolidLine); painter.drawLine(xx, _yoffset, xx, _ybottom); }
	else if (pixPerTick>0.0008) { painter.setPen(DashDotLine); painter.drawLine(xx,_yoffset,xx,_ybottom); }
      } else {
	if (pixPerTick>0.015625) { painter.setPen(DotLine); painter.drawLine(xx,_yoffset,xx,_ybottom); }
      }


      pos = pos + add;
      if (xx>_xright) draw=false;
      else xRight = xx;
    }
    painter.setPen(SolidLine);
    painter.drawLine(_xoffset,_yoffset,xRight,_yoffset); // draw horizontal borders
    painter.drawLine(_xoffset,_ybottom,xRight,_ybottom);
    //
    // horizontal lines
    //
    painter.setPen(SolidLine);
    for (int i=_yoffset; i<=_ybottom; i+=_height) {
      painter.drawLine(xLeft,i,xRight,i);
    }
    painter.setPen(SolidLine);






  // painter.drawLine(_xoffset, yy, _xright, yy);

  long len = 0;
  long xxLen = 0;
  Part * _part = _editor->part();
  for (Iterator i = Iterator(_editor); !i.done(); i++) {
    Event * event = (Event*) *i;
    Part *ptchn = i.change();
    _part = ptchn==0?_part:ptchn;
    if (event!=0) {
      pos = _part->start(event);
      len = event->duration();
      if (event->isA()==AUDIOEVENT) {
	ae = (AudioEvent*) event;
	xx = long((pos-_editor->left())*pixPerTick + _xoffset);
	xxLen = long((pos-_editor->left()+len)*pixPerTick + _xoffset)-xx;
	painter.fillRect(xx, _yoffset + yy*_height, xxLen, _height, Qt::lightGray);
	painter.drawRect(xx, _yoffset + yy*_height, xxLen, _height);
	painter.drawText(xx+2, _yoffset + yy*_height + 12, ae->name());
	yy++;
      }
    }
  }
  painter.end();
  bitBlt( this, 0, 0, &pix );

}


int KdeAudioContent::mouseY(int p) {
  if (p==-1) return _yoffset + _height*int((_moveY-_yoffset)/_height);
  else       return _yoffset + _height*int((p-_yoffset)/_height);
}

// ***************************************************
//
// MOUSE EVENT
// ***********
//
//

void KdeAudioContent::mousePressEvent( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();
  double pixPerTick = (_xright-_xoffset)*1.0/(_editor->right().ticks() - _editor->left().ticks());
  long pos = _editor->snap((_pressX-_xoffset)/pixPerTick) + _editor->left().ticks();
  if (me->button()==RightButton) {
    //
    // right button: context menu
    //
    _edit = _editor->getGrabEvent(pos);
    if (_edit) rbmenu->popup( mapToGlobal(me->pos()), 0 );
  } else {
    //
    // left button
    //
    _grab = _editor->getGrabEvent(pos);
    _grabX = int((_pressX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
    _grabY = mouseY();
    if (_grabX < 0) _grabX = 0;
    if (_grab==0) {
    } else {
      setCursor(ctrlFlag ? KdeCursor(KdeCursor::handCopy)
		: KdeCursor(KdeCursor::hand));
      _grabW = int(_grab->duration()*pixPerTick);
      moveWidget->setGeometry(_pressX-2, _grabY-2, _grabW, _height+4);
    }
  }
}


void KdeAudioContent::mouseMoveEvent( QMouseEvent * me ) {
  if (!_line->isVisible()) setFocus();
  _moveX = me->x();
  _moveY = me->y();
  double pixPerTick = (_xright-_xoffset)*1.0/(_editor->right().ticks() - _editor->left().ticks());
  long mpos = long((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  Event * over = _editor->getGrabEvent(mpos);


  if (_grab!=0) { // EVENT GRABBED
    int y = mouseY()-2;
    if (shftFlag) y = _grabY-2;
    moveWidget->move(_moveX-2, y);
    if (!moveWidget->isVisible()) moveWidget->show();
  } else {        // FREE
    if (_moveX > _xoffset) {
      if (_grabX > -1) {
	setCursor(QCursor(2));                          // CURSOR crosshair
	repaint(FALSE);
      } else {
	if (over && _editor->part()->get(int((_moveY-_yoffset)/_height))==over) {
	  setCursor(QCursor(13));                       // CURSOR pointing hand
	}
	else setCursor(QCursor(0));                      // CURSOR arrow
      }
    } else setCursor(QCursor(0));                       // CURSOR arrow
  }
  if (_moveX > _xoffset-20 && _moveX < _xoffset) _moveX = _xoffset;
}


void KdeAudioContent::mouseReleaseEvent( QMouseEvent * me ) {
  setCursor(QCursor(0));                        // CURSOR arrow
  double pixPerTick = (_xright-_xoffset)*1.0/(_editor->right().ticks() - _editor->left().ticks());
  long pos = _editor->snap((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  int _grabY2 = mouseY();
  long _grabX2 = long((_moveX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
  Part * pt = _editor->part();
  AudioTrack * tr = (AudioTrack*) pt->track();

  if (me->button()==RightButton) {
  } else if (_grab!=0) { // GRABBED EVENT
    if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // select
      if (shftFlag) {
	if (selectioN->hasEntry(_grab)) sonG->doo(new RemoveFromSelection(new Reference(_grab)));
	else                            sonG->doo(new AddToSelection(new Reference(_grab)));
      } else                            sonG->doo(new NewSelection(new Reference(_grab)));
    } else { // edit event
      if (ctrlFlag) { // copy event
	sonG->doo(new CopyEvent(Position(pos), _grab, _editor->part()));
      } else {        // move event
	sonG->doo(new MoveEvent(Position(pos), _grab, _editor->part()));
      }
    }
    moveWidget->hide();
  } else {      // FREE SPACE

    if (me->x() >= _xoffset) {
      if (abs(_grabY-_grabY2)<4) { // new Note
	sonG->doo(new AddElement(new AudioEvent(_editor->snap(_grabX)-_editor->part()->start(), 768, "untitled.wav"), _editor->part()));
      }
    }

  }
  _grab = 0;
  _grabX = -1;
  // _editor->repaint(FALSE);
}





void KdeAudioContent::moveCursor(long ticks) {
  int _xright = width()-24;
  int _xoffset = 24;
  double pixPerTick = (_xright-_xoffset)*1.0/(_editor->right().ticks() - _editor->left().ticks());
  long pos = long(ticks-_editor->left().ticks()*pixPerTick);
  if (pos > _xright) {
    _editor->moveleft(_editor->numberOfBars());
  }
  _position_cursor->move(pos-3);
}

#endif
#include "kdeAudioContent.moc"
