#ifndef _KDEAUDIOEDITOR_H_
#define _KDEAUDIOEDITOR_H_

#include <kmainwindow.h>

#include "prPartEditor.h"
#include "kdeEditorToolBar.h"

class Part;
class QPaintEvent;
class QResizeEvent;
class Event;
class PositionCursor;
class KdeAudioContent;

class KdeAudioEditor : public KMainWindow, public PrPartEditor
{
  Q_OBJECT

 private:
  QPopupMenu       * _filemenu;
  QPopupMenu       * _editmenu;
  QPopupMenu       * _gridmenu;
  KdeEditorToolBar * _toolbar;
  KdeAudioContent  * _content;
  int                _grid_id;

 public:
  KdeAudioEditor();
  KdeAudioEditor(Part * p);
  KdeAudioEditor(Track * t);
  ~KdeAudioEditor();
  void run();

  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);

 public slots:
  void paintEvent ( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void slotMenu( int );
  void slotGridMenu( int );
  
};

#endif
