#ifndef _KDEMASTEREDITOR_C_
#define _KDEMASTEREDITOR_C_

#include <iostream.h>

#include "kdeMasterEditor.h"
#include "part.h"
#include "track.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include "math.h"
#include "masterEvent.h"
#include "position.h"
#include "prPartEditor.h"
#include "iterator.h"
#include "removeElement.h"
#include "addElement.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorScrollBar.h"
#include "brahmsResources.h"
#include "kdeEditorMenuBar.h"

#include "event.h"
#include "song.h"

extern Song * sonG;

KdeMasterEditor::KdeMasterEditor(Part * p) : KMainWindow(0L, "MasterEventEditor"), PrPartEditor(MASTEREDITOR), index(-1), time1(4), time2(2), newPos(0), newTempo(120) {

  setCaption("Master Event Editor"); // TODO: part name
  _toolbarstate = true;
  _sliderstate = false;

  setMinimumWidth(720);
  setMinimumHeight(360);

  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);
  _scrollbar = new KdeEditorScrollBar(this,this);

  addToolBar( _toolbar ); _toolbar->setBarPos(KToolBar::Top); _toolbar->show();
  addToolBar( _scrollbar ); _scrollbar->setBarPos(KToolBar::Bottom); if (_sliderstate) _scrollbar->show(); else _scrollbar->hide();

  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _viewmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, 0, 0, _viewmenu);
  _viewmenu->setItemChecked(ID_VIEW_TOOLBAR, _toolbarstate);
  _viewmenu->setItemChecked(ID_VIEW_NOTEBAR , false);
  _viewmenu->setItemChecked(ID_VIEW_BUTTONBAR, false);
  _viewmenu->setItemChecked(ID_VIEW_SLIDER, _sliderstate);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_viewmenu,SIGNAL(activated(int)),SLOT(slotViewMenu(int)));

  _viewmenu->setItemEnabled(ID_VIEW_NOTEBAR, false);
  _viewmenu->setItemEnabled(ID_VIEW_BUTTONBAR, false);



  //
  // Contents:
  // =========
  //

  QWidget * center = new QWidget(this); center->show();

  QLabel * title = new QLabel("Mastertrack",center);
  title->setGeometry(2,2,186,22);

  view = new QListBox(center);
  view->setGeometry(2,24,616,154);
  showView();
  view->show();
  connect(view,SIGNAL(selected(int)),SLOT(enableDelete(int)));

  QLabel * lPos = new QLabel("position",center);
  lPos->setGeometry(2,184,64,18);

  QLabel * lTempo = new QLabel("tempo",center);
  lTempo->setGeometry(68,184,64,18);

  QLabel * lMeter = new QLabel("meter",center);
  lMeter->setGeometry(124,184,64,18);

  posline = new QLineEdit(center);
  posline->setGeometry(2,204,64,18);
  posline->show();

  templine = new QLineEdit(center);
  templine->setGeometry(68,204,64,18);
  templine->show();

  metline0 = new QLineEdit(center);
  metline0->setGeometry(124,204,64,18);
  metline0->show();

  /*  metline1 = new QLineEdit(center);
  metline1->setGeometry(124,236,30,18);
  metline1->show();
  */
  QPushButton * addTempoBtn = new QPushButton("set tempo",center);
  addTempoBtn->setGeometry(2,224,92,20);
  addTempoBtn->show();
  connect(addTempoBtn,SIGNAL(released()),SLOT(addTempo()));

  QPushButton * addMeterBtn = new QPushButton("set meter",center);
  addMeterBtn->setGeometry(96,224,92,20);
  addMeterBtn->show();
  connect(addMeterBtn,SIGNAL(released()),SLOT(addMeter()));

  delBtn = new QPushButton("remove",center);
  delBtn->setGeometry(2,250,48,48);
  delBtn->show();
  connect(delBtn,SIGNAL(released()),SLOT(remove()));
  delBtn->setEnabled(false);

  QPushButton * exit = new QPushButton(" OK ",center);
  exit->setGeometry(140,250,48,48);
  exit->show();
  connect(exit,SIGNAL(released()),SLOT(exit()));

  setCentralWidget(center);
  update();
  sonG->updateGui();
}

void KdeMasterEditor::enableDelete(int i) {
  index = i;
  delBtn->setEnabled(true);
  int k = 0;
  /* for (KbAtom * a = part->gFirstAtom();(a!=0)&&(k<index);a=a->gNext()) {
    if (a->isMasterEvent()) k++;
    }*/
  Event * ev = 0;
  Part * _part = part();

  for (Iterator i = Iterator(_part); !i.done() && k<index; i++) {
    ev = (Event*) *i;
    if (ev!=0 && ev->isA()==MASTEREVENT) k++;
  }

  if (ev!=0) {
    MasterEvent * te = (MasterEvent*) ev;
    char * x = new char[40];
    Position pos = te->internalStart();
    // sprintf(x,"%d. %d. %d\0",pos.gBar(part),pos.gBeat(part),pos.gTicks(part));
    int a = 0; int b = 0; int c = 0;
    sonG->bbt(a,b,c,pos);
    snprintf(x,30," %d. %d. %d",a,b,c);
    posline->setText(x);
    if (te->tempo()>0) { sprintf(x,"%d\0",te->tempo()); templine->setText(x); metline0->setText(""); }
    else { sprintf(x,"%d / %d\0",te->meter0(),te->meter1()); metline0->setText(x); templine->setText(""); }
    delete[] x;
  }
}

KdeMasterEditor::~KdeMasterEditor() {
  delete view;
  delete posline;
  delete templine;
  delete metline0;

}

void KdeMasterEditor::pos() {
  posline->clearFocus();
  const char * line = posline->text();
  int x1 = atoi(line);
  for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
  int x2 = atoi(line);
  for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
  int x3 = atoi(line);
  // x1 . x2 . x3

  newPos = Position(x1,x2,x3);

  // int ticks = int(1536.0*time1/pow(2,time2));
  // newPos = ticks*(x1-1) + ticks*(x2-1)/time1 + x3;
  //posline->setText("");
}

void KdeMasterEditor::temp() {
  templine->clearFocus();
  newTempo = atoi(templine->text());
  templine->setText("");
}

void KdeMasterEditor::meter() {
  metline0->clearFocus();
  const char * mtxt = metline0->text();
  newMeter0 = atoi(mtxt);
  int i = 0;
  for (;(mtxt[0]!='/')&&(i<10);i++) mtxt++;
  mtxt++;
  newMeter1 = atoi(mtxt);
  if (newMeter1<1) newMeter1 = 4;
  metline0->setText("");
}

void KdeMasterEditor::addTempo() {
  pos();
  temp();
  Part * _part = part();
  if ((newPos>=0)&&(newTempo>0)) {
    if (index!=-1) {
      int k = 0;
      Event * ev = 0;
      for (Iterator i = Iterator(_part); !i.done() && k<index; i++) {
	ev = (Event*) *i;
	if (ev!=0 && ev->isA()==MASTEREVENT) k++;
      }
      if (ev!=0) sonG->doo(new RemoveElement(ev, _part));
    }
    MasterEvent * newTE = new MasterEvent(newPos,newTempo);
    sonG->doo(new AddElement(newTE, _part));

    showView();
  }
}

void KdeMasterEditor::addMeter() {
  pos();
  meter();
  Part * _part = part();
  if ((newMeter0>0) && (newMeter1>0) && (newPos>=0)) {
    if (index!=-1) {
      int k = 0;
      Event * ev = 0;
      for (Iterator i = Iterator(_part); !i.done() && k<index; i++) {
	ev = (Event*) *i;
	if (ev!=0 && ev->isA()==MASTEREVENT) k++;
      }
      if (ev!=0) sonG->doo(new RemoveElement(ev, _part));
    }
    MasterEvent * newME = new MasterEvent(newPos,newMeter0,newMeter1);
    sonG->doo(new AddElement(newME, _part));

    showView();
  }
}

void KdeMasterEditor::remove() {
  int k = 0;
  Event * ev = 0;
  Part * _part = part();
  for (Iterator i = Iterator(_part); !i.done() && k<index; i++) {
    ev = (Event*) *i;
    if (ev!=0 && ev->isA()==MASTEREVENT) k++;
  }
  if (ev!=0) {
    if ((k>index) || (ev->isA()==MASTEREVENT)) printf("PANIC KDEMASTEREDITOR");
    else sonG->doo(new RemoveElement(ev, _part));
  }
  showView();
}

void KdeMasterEditor::exit() {
  delete this;
}

void KdeMasterEditor::insertTE(MasterEvent * te) {
  char * x = new char[40];
  Position pos = part()->start(te);
  int a = 0; int b = 0; int c = 0;
  sonG->bbt(a,b,c,pos);
  if (te->tempo()==0) { // meter
    snprintf(x,30," %d. %d. %d :      %d / %d",a,b,c,te->meter0(),te->meter1());
  } else { // tempo
    snprintf(x,30," %d. %d. %d : %d",a,b,c,te->tempo());
  }
  view->insertItem(x);
  delete[] x;
}

void KdeMasterEditor::showView() {

  view->clear();
  Event * ev = 0;
  Part * _part = part();
  for (Iterator i = Iterator(_part); !i.done(); i++) {
    ev = (Event*) *i;
    if (ev!=0 && ev->isA()==MASTEREVENT) insertTE( (MasterEvent*) ev);
  }
  view->clearSelection();
  index = -1;
}

int KdeMasterEditor::Pitch(int i) {}



void KdeMasterEditor::update() {
  cout << "update" << endl;
}

void KdeMasterEditor::setCursorPosition(long ticks) {
  // cout << "pos: " << ticks << endl;
}

void KdeMasterEditor::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeMasterEditor::print() {
}

void KdeMasterEditor::settings() {
}

void KdeMasterEditor::slotMenu(int i) {
  // cout << i << endl;
  _toolbar->commandCallback(i);
}


void KdeMasterEditor::slotViewMenu(int i) {
  bool ch = _viewmenu->isItemChecked(i);
  ch = !ch;
  _viewmenu->setItemChecked(i,ch);
  switch(i) {
  case ID_VIEW_TOOLBAR:
    if (ch) _toolbar->show(); else _toolbar->hide();
    break;
  case ID_VIEW_NOTEBAR:
    //if (ch) _notebar->show(); else _notebar->hide();
    break;
  case ID_VIEW_BUTTONBAR:
    //if (ch) _buttonbar->show(); else _buttonbar->hide();
    break;
  case ID_VIEW_SLIDER:
    if (ch) _scrollbar->show(); else _scrollbar->hide();
    break;
  }
}

void KdeMasterEditor::keyPressEvent ( QKeyEvent * ) {
  // _content->keyPressEvent(key);
}

void KdeMasterEditor::keyReleaseEvent ( QKeyEvent * ) {
  // _content->keyReleaseEvent(key);
}

#endif
#include "kdeMasterEditor.moc"
