#ifndef _KDESCORECONTENT_H_
#define _KDESCORECONTENT_H_

#include <qframe.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qpen.h>

#include "qtScoreSymbols.h"
#include "lyricsEdit.h"

#include "prScoreEditor.h"

class QPaintEvent;
class QLineEdit;
class QKeyEvent;
class Track;
class Part;
class Note;
class Bow;
class Expression;
class Symbol;
class Lyrics;
class QtScoreGroup;
class QPopupMenu;
class KdeEditorToolBar;
class KdeEditorNoteBar;
class KdeEditorButtonBar;
class KdeEditorScrollBar;
class KdeEditInfo;
class KdeScoreEditor;
class KdeKeyChooser;
class KdeSPD;
class PositionCursor;

class KdeScoreContent : public QFrame
{
  // friend QtChooser;
  friend QtSymbols;
  // friend QtSPD;

  Q_OBJECT

 private:
  KdeScoreEditor * _editor;
  KdeEditorNoteBar * _notebar;
  KdeEditorToolBar * _toolbar;
  KdeEditorButtonBar * _buttonbar;
  KdeEditorScrollBar * _scrollbar;
  QPopupMenu * rbmenu;
  QtSymbols * scoreAux;
  QtSymbols * noteExt;
  QPixmap imgSign[6];
  QPixmap imgNote[2];
  QPixmap arrBreak[10];
  QPixmap imgFlag[2];
  QPixmap noteAccent[21];
  QPixmap scoreSymbol[33];
  QPixmap cursorPM;
  QBitmap cursorBM[9];
  QCursor * cursor[9];
  QCursor * symbolcursor1;
  QCursor * symbolcursor2;
  QCursor * lyricscursor1;
  QCursor * lyricscursor2;
  PositionCursor * _position_cursor;
  Part * _part;
  Part * master;
  double pixPerTick;
  double posCoef;
  int yAux;
  int enhValue;
  int yytext;
  int scrKey;
  int clef;
  int nKey;
  int yoffset;
  int xoffset;
  int xofftime;
  char t1[5];
  char t2[5];
  int met0;
  int met1;
  int curMet0;
  int curMet1;

  int draw(Position lpos, Position rpos, QPainter * score, Part * part);
  int DOT(int);
  // old stuff:

  void showFreq();
  int Pitch(int);
  void createLyrics(Note*,int,int);
  void createText(Symbol*,int,int);

  Note * _grab;
  int _mousey;
  int _pressX;
  int _pressY;
  int _moveX;
  int _moveY;
  long _grabX;
  int _grabY;
  int _grabW;
  bool shftFlag;
  bool ctrlFlag;
  bool suprFlag;

  bool showIN;
  bool showTN;
  bool showLYR;
  bool showVOL;
  Note * lyricsNote;
  Part * lyricsPart;
  Lyrics * oldLyr;
  int N;
  int y;
  int lyrX;
  int lyrY;
  Position freePos;
  Position brkPos;
  // KbPosition oldFreePos;
  int ticksPerBar;
  int brk;
  int timeDelta;
  int xb;
  int system;
  int yOff;
  int ySys;
  int ySysGrab;

  // KbPosition xLeft;
  // KbPosition xRight;
  int oldCurBar;
  int curBar;
  int curBeat;
  int curTick;
  int leftBar;
  int leftBeat;
  int leftTick;
  int leftMet0;
  int leftMet1;

  int oldTimeBar;
  int n;
  int scrClef;
  int i;
  int j;
  int k;
  int yyOld;
  int xxOld;
  int xxCol;
  int yFlag1;
  double nFlag[24];
  double nFlag1;
  int nnFlag1;
  int xFlag[24];
  int yFlagMax[24];
  int yFlag1Max;
  int yFlagMin[24];
  int yFlag1Min;
  int yyyMin;
  int yyyMax;
  int flag;
  int maxNnFlags;
  int triX0;
  int scorelength;
  int freq;
  int oldfreq;
  int vel;
  int len;
  int enh;
  int chan;
  int stemDir;
  Note * next;
  double deltapos;
  int step;
  int yy;
  int sg;
  int xx;
  int sgMem;
  int xxShft;
  QPixmap img;
  int akkordmin;
  int akkordmax;
  int akkordmaxOld;
  int akkordlen;
  int dot;
  int triMem;
  int triYmax;
  int triYmin;
  int triDX;
  double cl;
 
  int x0; int x1; int x2;
  QPen flagPen;
  int neck;

  double xBrk[5];
  double llBrk[5];
  int bb;
  // int x0; int x1; int x2;
  int volGrabX1;
  int volGrabX2;
  int volGrabY1;
  int volGrabY2;
  bool showAUX;
  bool showNEXT;
  // Buttonbar * buttonbar;
  bool keyChooser;
  KdeKeyChooser * myKeyChooser;
  KdeSPD * myPrintDialog;
  LyricsEdit * lyrLine;
  QLineEdit * txtLine;
  int extNoteElement;
  int auxScoreElement;
  Note * extNote;
  int extNoteParameter;
  Expression * noteExp;
  Bow * noteBow;
  Symbol * symbol;
  Symbol * textElement;
  QtScoreGroup * firstGroup;
  int _active_system;

 public:
  KdeScoreContent( QFrame * , KdeScoreEditor * , KdeEditorToolBar * , KdeEditorNoteBar *, KdeEditorButtonBar * );
  ~KdeScoreContent();

  // old:
  QPixmap imgClef[15];
  QPixmap imgFlat;
  QPixmap imgSharp;
  int gEnhValue();
  void sEnhValue(int e);
  void updateCursor();
  void setTool(int);
  int tool();
  void print();
  void printIt();
  void addMenuEntries();
  void settings();
  void clearKeyChooser();
  void setLyrics(bool);
  void moveCursor(int ticks);

 public slots:
  void paintEvent(QPaintEvent*);
  void mousePressEvent ( QMouseEvent * );
  void mouseMoveEvent  ( QMouseEvent * );
  void mouseReleaseEvent ( QMouseEvent * );
  void keyPressEvent ( QKeyEvent * );
  void keyReleaseEvent ( QKeyEvent * );
  void setLyrics();
  void setText();
  void glueNote();
  void splitNote();
  void deleteNote();
  void removeSymbols();
  void removeBow();
  void flipStem();
  void flipBow();

};

#endif
