#ifndef _TEXTSCOREEDITOR_CPP_
#define _TEXTSCOREEDITOR_CPP_

#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <math.h>

#include "part.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "position.h"
#include "addElement.h"

#include "textScoreEditor.h"
#include "textProgress.h"

#include "scoreGroup.h"
#include "scoreBreak.h"
#include "scoreChord.h"
#include "systemIterator.h"
#include "scoreBar.h"
#include "screen.h"

extern Song * sonG;


TextScoreEditor::TextScoreEditor() : PrScoreEditor() {
  run();
}

TextScoreEditor::TextScoreEditor(Part * p) : PrScoreEditor(p) {
  run();
}

TextScoreEditor::TextScoreEditor(Track * t) : PrScoreEditor(t) {
  run();
}

TextScoreEditor::~TextScoreEditor() {
  delete _screen;
}

void TextScoreEditor::run() {
  _screen = new Screen();
  _bars = 2;

  char line[400];
  const char * cmd;
  bool exit = false;
  update();
  while (!exit) {
    cout << "\n[ " << part()->size() << " ] $ ";
    cin.getline(line,400,'\n');
    Vector vec = Vector(line);
    cmd = ((String*) (vec)[0])->getValue();
    if (strcmp(cmd,"")==0) { update(); }
    if (strcmp(cmd,"help")==0) {
      cout << endl;
      cout << " help       - shows this list" << endl;
      cout << " exit       - leaves the edit mode" << endl;
      cout << " +          - moves one bar to the right" << endl;
      cout << " -          - moves one bar to the left" << endl;
      cout << " zoomin     - zooms in" << endl;
      cout << " zoomout    - zooms out" << endl;
      cout << " up         - activates one track up" << endl;
      cout << " down       - activates one track below" << endl;
      cout << " add pos pitch len - adds a note to the part" << endl;
      cout << " play       - plays the part" << endl;
      cout << " res        - sets the resolution for score editing" << endl;
      cout << " overlap    - toggles the overlap mode on and off for score editing" << endl;
    }
    if (strcmp(cmd,"exit")==0) { exit = true; }
    if (strcmp(cmd,"-")==0) { moveright(1); }
    if (strcmp(cmd,"+")==0) { moveleft(1); }
    if (strcmp(cmd,"zoomin")==0) { zoomin(); }
    if (strcmp(cmd,"zoomout")==0) { zoomout(); }
    if (strcmp(cmd,"up")==0) { moveUp(); }
    if (strcmp(cmd,"down")==0) { moveDown(); }
    if (strcmp(cmd,"play")==0) { sonG->play(new TextProgress(), part(),_leftPos.ticks(),_rightPos.ticks()); }
    if (strcmp(cmd,"res")==0) {
      int par = atoi(((String*) (vec)[1])->getValue());
      setPartResolution(par);
    }
    if (strcmp(cmd,"overlap")==0) { setNoOverlap(!noOverlap()); }
    if (strcmp(cmd,"add")==0) {
      // for example: "add 1.1.0 c4 192"
      const char * newpos = ((String*) (vec)[1])->getValue();
      const char * newpitch = ((String*) (vec)[2])->getValue();
      int newlen = atoi(((String*) (vec)[3])->getValue());
      cout << "added note " << newpos << ":" << newpitch << ":" << newlen << endl;
      long int vel = 100;
      Note * n = new Note((char*)newpitch,vel,newlen,Position((char*)newpos,0),0);
      sonG->doo(new AddElement(n,part()));

    }
  }
}


void TextScoreEditor::update() {
  // cout << "\ec" << endl;
  cout << char(27) << "c" << endl;
  cout << "Score Editor, resolution: " << resolution() << ", no-overlap: " << noOverlap() << "\n" << endl;

  SystemIterator si = SystemIterator(this);
  // ScoreBar * sb = (ScoreBar*) *si;
  // sb->paint(this);

  _screen->clear();

  int i=0;
  for (;!si.done();) {
    ScoreBar * sb = (ScoreBar*) *si;
    // cout << *sb << endl;
    sb->paint(this, i++*_screen->width()*1.0/_bars);
    si++;
  }

  _screen->update();
}

void TextScoreEditor::gui(GuiEvents,bool) {

}

void TextScoreEditor::print() {

}

void TextScoreEditor::settings() {

}

void TextScoreEditor::setCursorPosition(long ticks) {
  cout << "cursor at " << ticks << endl;
}

int TextScoreEditor::editorWidth() const { return _screen->width(); }


#endif
