#ifndef _TEXTSCOREPAINTER_H_
#define _TEXTSCOREPAINTER_H_

#include "prScorePainter.h"

class ScoreBar;
class ScoreGroup;
class ScoreChord;
class ScoreBreak;
class Table;
class Screen;

/** The TextScorePainter is instantiated only once (as asingleton)!
 *  Thus it should not contain any editor-specific members. It is
 *  thought only to provide methods to paint the ScoreObjects
 *  (bars, groups, chords and breaks).
 *  The few private members are always(!!!) to used temporarily.
 */
class TextScorePainter : public PrScorePainter
{
  friend class TextFactory;

 private:
  TextScorePainter();
  char noteImg;

  /* returns the x-displacement due to the information drawn
   */
  int drawInfo(ScoreBar * bar, Screen * screen, int off);
  
 public:

  virtual void paintBar(ScoreBar*, PrScoreEditor*, Table*, int, int, int style=0);
  virtual void paintGroup(ScoreGroup*, PrScoreEditor*, Table*, int, int);
  virtual void paintChord(ScoreChord*, PrScoreEditor*, Table*, int, int);
  virtual void paintBreak(ScoreBreak*, PrScoreEditor*, int, int);
  virtual int indentSystem(ScoreBar*);
};


#endif
