#ifndef _ATOMA_H_
#define _ATOMA_H_

#include "element.h"

class ostream;

/**
 * Classes derived from the abstract class Atoma do not contain further elements in a canonical way. (The class Note still contains
 * a table of elements, but rather as a member, not by inheritance). Atomas can be printed and copied.
 **/
class Atoma : public Element
{
 private:

 public:

  /**
   * Default constructor
   **/
  Atoma() {};

  /**
   * Constructor used by copy()
   **/
  Atoma(const Atoma&,Type);

  /**
   * Overload this destructor to free memory!
   **/
  virtual ~Atoma();

  /**
   *  Print has to be implemented
   **/
  virtual ostream & print(int,ostream&) const = 0;

  /**
   * Flush has to be implemented
   **/
  virtual void flush(const char*) const = 0;

  /**
   * Copy has to be implemented
   **/
  virtual Element * copy() const = 0;

  /**
   * Atomas cannot be Tracks
   **/
  virtual bool isTrack() const { return false; }
};

#endif
