
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2010
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include "bristol.h"
#include "bristolmidi.h"

extern int bristolPressureEvent();

int rate = 100000;

void
sendOnePressure(int mh, int client, int value)
{
	bristolPressureEvent(mh, client, 0, value);
}

void
sendOneNRP(int mh, int client, int nrp, int value)
{
	int cc, cf, vc, vf;

	cc = (nrp >> 7) & 0x7f;
	cf = nrp & 0x7f;
	vc = (value >> 7) & 0x7f;
	vf = value & 0x7f;

//	printf("sending %i %i %i %i\n", cc, cf, vc, vf);

	bristolMidiControl(mh, client, 0, MIDI_GM_NRP, cc);
	bristolMidiControl(mh, client, 0, MIDI_GM_NRP_F, cf);
	bristolMidiControl(mh, client, 0, MIDI_GM_DATAENTRY, vc);
	bristolMidiControl(mh, client, 0, MIDI_GM_DATAENTRY_F, vf);
	/* NULL */
//	bristolMidiControl(mh, client, 0, MIDI_GM_NRP, 127);
//	bristolMidiControl(mh, client, 0, MIDI_GM_NRP_F, 127);
}

void
sendManyNRP(int mh, int client, int nrp, int step, int delay)
{
	int count;

	for (count = 0; count < 16384; count+=128)
	{
		sendOneNRP(mh, client, 13, count);
		usleep(4000);
	}
	for (; count >= 0; count-=128)
	{
		sendOneNRP(mh, client, 13, count);
		usleep(4000);
	}
}

int
main(int argc, char *argv[])
{
	int mh, client = 128, argCount = 1;
	int count = 0x7fffffff;
	int cycle = 2;

	char *device = "bristolng";

	if ((argc > 1) && ((strcmp(argv[argCount], "-help") == 0)
		|| (strcmp(argv[argCount], "--help") == 0)))
	{
		printf("%s: this is for bristol SQA testing, it only streams note events\n\
%s [-target <id = 128>] [-cycle <0-2>] [-count <n>] [-rate <ms>]\n",
		argv[0],
		argv[0]);
		exit(0);
	}

	while (argc > argCount) {
		if ((strcmp(argv[argCount], "-rate") == 0) && (argCount < argc))
		{
			if ((rate = atoi(argv[argCount + 1])) < 0)
				rate = 100;
			rate *= 1000;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-target") == 0) && (argCount < argc))
		{
			if ((client = atoi(argv[argCount + 1])) < 0)
				client = 128;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-count") == 0) && (argCount < argc))
		{
			if ((count = atoi(argv[argCount + 1])) < 0)
				count = 0x7fffffff;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-cycle") == 0) && (argCount < argc))
		{
			cycle = atoi(argv[argCount + 1]);
			argCount++;
		}

		argCount++;
	}

	printf("Target %i, count %i, cycle %i\n", client, count, cycle);

	if ((mh = bristolMidiOpen(device, BRISTOL_CONN_SEQ|BRISTOL_WRONLY,
		-1, BRISTOL_REQ_ALL, NULL, NULL)) < 0)
	{
		printf("%s: could not open midi connection\n", argv[0]);
		exit(1);
	}

	sendOnePressure(mh, client, 64);

return(0);
	sendOneNRP(mh, client, 13, 1);

	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);
	sendManyNRP(mh, client, 13, 256, 1000);

	exit(0);
}

