// console.cpp
// Console
// by Joe Flint
// OpenGL console

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "console.h"
#include "SDL.h"

stringstream Console::out;
stringstream Console::con_cmd;
string Console::currentCommand;

vector<string> Console::buffer;

double Console::hideoff = 0;

bool Console::on = false;
bool Console::cmdIsSet = false;
Timer Console::anim;

void Console::draw()
{
	string dispstr = "\n";
   static string commands = "";
	string dispcmd;
   string temp;

	// Get the lastest output
	if( out.str() != "" ) {
		while( getline( out, temp ) )
			buffer.push_back( temp );
	}

	out.clear();

	for( int i = 5; i >= 0; i-- ) {
		if( int( buffer.size() - i - 1 ) >= 0 ) {
			dispstr += buffer[buffer.size() - i - 1];
		}
		dispstr += "\n";
	}
   
   // Get whatever the user has typed to the "command line"
   if( con_cmd.str() != "" ) {
	   getline( con_cmd, temp );
      if (temp[0] == '\r') { 
         cmdIsSet = true;;
         currentCommand = commands;
         commands = ""; 
      } else if (temp[0] == '\b') {
         commands = commands.substr(0, commands.length()-1);
      } else {
         commands += temp;
      }
	}
	con_cmd.clear();
   
   // Cursor
   /*if (SDL_GetTicks()%1000 < 500) {
      dispcmd = commands + "_";
   } else {
      dispcmd = commands;
   }*/
	dispcmd = commands;
   
	if( on || anim.started() ) {
		glDisable(GL_LIGHTING);
		glDisable(GL_DEPTH_TEST);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
		glColor4d( 0.3, 0.3, 0.3, 0.5 );
		glPushAttrib(GL_TRANSFORM_BIT);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();

		glLoadIdentity();
		gluOrtho2D(-1.3333,1.3333,-1,1);
		glPopAttrib();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
								
		if( anim.started() ) {
			hideoff = anim.value();
			glTranslated( 0, hideoff, -1 );
			anim++;
		} else {
			glTranslated( 0, 0, -1 );
		}
		glBegin( GL_QUADS );
		glVertex2d( -1.3333, 0.43 );
		glVertex2d( 1.3333, 0.43 );
		glVertex2d( 1.3333, 1 );
		glVertex2d( -1.3333, 1 );
		glEnd();
		glScaled( 0.0015, 0.0015, 0.0015 );
		glColor4d( 1, 1, 1, 0.90 );
		FontLoader::print( -1.3, 1, dispstr.c_str() );
		glColor4d( 1, 0.3, 0.3, 0.90 );
		FontLoader::print( -1.3, 0.46, "$" );
		glColor4d( 1, 1, 1, 0.90 );
		FontLoader::print( -1.25, 0.46, dispcmd.c_str() );
		if (SDL_GetTicks()%1000 < 500) {
			glLoadIdentity();
			glMultMatrixf(FontLoader::lastMatrix);
			glBegin( GL_QUADS );
			glVertex2d( -2, -5 );
			glVertex2d( 2, -5 );
			glVertex2d( 2, 35 );
			glVertex2d( -2, 35 );
			glEnd();
		}
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode( GL_MODELVIEW );
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_LIGHTING);
		glDisable(GL_BLEND);
	}
}

void Console::show()
{
	bool contanim = false;
	on = true;

	// Continue current animation if possible
	if( anim.started() )
		contanim = true;

	anim.stop();

	anim.setRange( 0.57, 0 );
	anim.setDuration( 0.5 );

	if( contanim )
		anim.setProgress( hideoff );

	anim.start();
}

void Console::hide()
{
	bool contanim = false;
	on = false;

	// Continue current animation if possible
	if( anim.started() )
		contanim = true;

	anim.stop();

	anim.setRange( 0, 0.57 );
	anim.setDuration( 0.5 );

	if( contanim )
		anim.setProgress( hideoff );

	anim.start();
}

void Console::toggle()
{
	if( on )
		hide();
	else
		show();
}

bool Console::isOn() {
   return on;
}

void Console::getKeyboardInput(bool *keys) {
	static char numrow[] = ")!@#$%^&*(";
	if (true == on) {
		for (int i = (int)SDLK_BACKSPACE; i < (int)SDLK_DELETE; i++) {
			if (keys[i]) {
				char c = (char)i;
				if(keys[SDLK_LSHIFT] || keys[SDLK_RSHIFT]) {
					if(c >= 'a' && c <= 'z')
						con_cmd << (char)(('A' - 'a') + c);
					// Special case to escape the '%'
					if(c == '5')
						con_cmd << "%%";
					else if(c >= '0' && c <= '9' )
						con_cmd << numrow[c - '0'];
				} else {
					con_cmd << c;
				}
				keys[i] = false;
			}
		}
	} 
	return;
}

string Console::fetchCommand() {
   if (cmdIsSet) {
      cmdIsSet = false;
      return currentCommand;
   } else {
      return "";
   };
}
