/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "Configurator.h"
#include "ConfigFnBtn.h"
#include "Shared.h"
#include "DisplayConfig.h"
#include "ConsoleConfig.h"
#include "ExtConfig.h"
#include "Config.h"
#include <qtabbar.h>
#include <qwidgetstack.h>
#include <qlayout.h>
#include <qpushbutton.h>

/*------- local constants:
-------------------------------------------------------------------*/
const QString Configurator::Caption         = QT_TR_NOOP( "Program configuration" );
const QString Configurator::DisplayTabLabel = QT_TR_NOOP( "&Panels" );
const QString Configurator::FnBtnTabLabel   = QT_TR_NOOP( "Function &buttons" );
const QString Configurator::ConsoleTabLabel = QT_TR_NOOP( "&Console" );
const QString Configurator::ExtTabLabel     = QT_TR_NOOP( "&Extensions" );


//*******************************************************************
// Configurator                                          CONSTRUCTOR
//*******************************************************************
Configurator::Configurator( QWidget* const in_parent )
: QDialog( in_parent )
, d_tab_bar( new QTabBar( this ))
, d_widget_stack( new QWidgetStack( this ))
, d_close_btn( new QPushButton( tr(Shared::CloseBtnLabel), this ))
{
	setCaption( tr(Caption) );
	setFont( Config::instance()->lfs_default_font() );
	Shared::add_icon( d_close_btn, Shared::CloseIcon );

	d_tab_bar->insertTab( new QTab( tr(DisplayTabLabel) ), DisplayTabIdx );
	d_tab_bar->insertTab( new QTab( tr(FnBtnTabLabel) ), FnBtnTabIdx );
	d_tab_bar->insertTab( new QTab( tr(ConsoleTabLabel) ), ConsoleTabIdx );
	d_tab_bar->insertTab( new QTab( tr(ExtTabLabel) ), ExtTabIdx );
	
	d_widget_stack->addWidget( new DisplayConfig( this ), DisplayTabIdx );
	d_widget_stack->addWidget( new ConfigFnBtn( this ), FnBtnTabIdx );
	d_widget_stack->addWidget( new ConsoleConfig( this ), ConsoleTabIdx );
	d_widget_stack->addWidget( new ExtConfig( this ), ExtTabIdx );

	QVBoxLayout* const main_layout = new QVBoxLayout( this );
	main_layout->setSpacing( Shared::LayoutMargin );
	main_layout->setMargin( Shared::LayoutMargin );

	main_layout->addWidget( d_tab_bar );
	main_layout->addWidget( d_widget_stack );
	
	QHBoxLayout* const btn_layout = new QHBoxLayout;
	btn_layout->addStretch( Shared::OverStretch );
	btn_layout->addWidget( d_close_btn );
	main_layout->addLayout( btn_layout );
	
	connect( d_close_btn, SIGNAL( clicked() ), this, SLOT( slot_close() ));
	connect( d_tab_bar, SIGNAL( selected( int ) ), this, SLOT( slot_set_tab( int )));
}
// end of Configurator

//*******************************************************************
// slot_close                                           PRIVATE slot
//*******************************************************************
void Configurator::slot_close()
{
	accept();
}
// end of slot_close

//*******************************************************************
// slot_set_tab                                         PRIVATE slot
//*******************************************************************
void Configurator::slot_set_tab( const int in_idx )
{
	d_widget_stack->raiseWidget( in_idx );
	d_tab_bar->setCurrentTab( in_idx );
}
// end of slot_set_tab
