/********************************************************************
 * Copyright (C) 2005,2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SHARED_H
#define INCLUDED_SHARED_H

/*------- include files:
------------------------------------------------------------------*/
#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

/*------- forward declaration:
-------------------------------------------------------------------*/
class QPushButton;

/*------- class declaration:
--------------------------------------------------------------------*/
class Shared : public QObject
{
    Q_OBJECT

// ******* members *******
public:
	enum
	{
		FILE = 0,
		DIRECTORY
	};
private:
	static const char* const MyDir;
	static const char* const MyTmpDir;
	static const char* const MyPackDir;
	static const char* const MsgBoxDelErrorCaption;
	static const char* const MsgBoxDelFileError;
	static const char* const MsgBoxDelDirError;
public:	
    static bool              d_break;
	static const int         LayoutMargin;
	static const int         LayoutSpacing;
	static const int         OverStretch;
	static const char* const DeletingFileMsg;
	static const char* const LicenceFileName;
	static const char* const ThisDir;
	static const char* const ParentDir;
	static const char* const ShellCd;
	static const char* const NotReadableDir;
	static const char* const FTP_Unconnected;
	static const char* const FTP_HostLookup;
	static const char* const FTP_Connecting;
	static const char* const FTP_Connected;
	static const char* const FTP_LoggedIn;
	static const char* const FTP_Closing;
	static const char* const FTP_Unknown;
    static const char* const DirSep;
	static const char* const DateTimeMuster;
	static const char* const MenuHelp;
	static const char* const MenuAccess;
	static const char* const MenuView;
	static const char* const MenuEdit;
	static const char* const MenuCopy;
	static const char* const MenuRename;
	static const char* const MenuMkDir;
	static const char* const MenuDelete;
	static const char* const MenuPack;
	static const char* const MenuQuit;
	static const char* const MenuEmpty;
	static const char* const CmpDirIcon;
	static const char* const CloseIcon;
	static const char* const AcceptIcon;
	static const char* const ApplyIcon;
	static const char* const BreakIcon;
	static const char* const SaveIcon;
	static const char* const ReloadIcon;
	static const char* const ResetIcon;
	static const char* const TreeIcon;
	static const char* const CloseBtnLabel;
	static const char* const AcceptBtnLabel;
	static const char* const SaveBtnLabel;
	static const char* const CancelBtnLabel;
	static const char* const ContinueBtnLabel;
	static const char* const BreakBtnLabel;
	static const char* const RunBtnLabel;
	static const char* const YesBtnLabel;
	static const char* const NoBtnLabel;
	static const char* const OkBtnLabel;
	static const char* const ReloadBtnLabel;
	static const char* const ApplyBtnLabel;
	static const char* const ResetBtnLabel;
	static const char* const SelectBtnLabel;
	static const char* const Information;
	static const char* const Yes;
	static const char* const No;
	static const char* const KonsoleCall;
    //...................................................................
    static const QChar   Spc;
	static const QChar   Point;
	static const QChar   Colon;
	static const QChar   Semicolon;
	static const QChar   Stern;
	static const QChar   WidthMarker;
	static const QChar   Ampersand;
    static const QString TouchPrgName;
    static const QString VersionMajor;
    static const QString VersionMinor;
    static const QString ProgramVersion;
    static const QString ProgramName;
    static const QString EmptyStr;
// ******* MEMBERS *******
private:
	static QString d_home_directory;
	static bool    d_file_filter_activ;
	static QString d_tmp_buffer;

// ******* methods *******
public:
	static void     toggle_file_filter      ();
	static void     toggle_file_filter      ( const bool in_flag );
	static int      get_file_filter         ();
	static QString  get_home_dir            ();
	static QString  get_my_dir              ();
	static QString  get_tmp_dir             ();
	static QString  get_pack_dir            ();
	static QString  get_subpath             ( const QString& in_base_path, const QString& in_current_path );
	static bool     create_path             ( const QString& in_existing, const QString& in_subdirs );
	static bool     remove_path_and_content ( const QString&, bool = FALSE, bool = FALSE, QDialog* = 0 );
	static bool     remove_file             ( const QString&, bool = FALSE, bool = FALSE, QDialog* = 0 );
	static void     add_icon                ( QPushButton* const in_button, const QString& in_icon_name );
	static bool     is_binary_file          ( const QString& in_fpath );
	static void     polish                  ( QWidget* const, const int, const int );
	static void     polish                  ( QWidget* const, const QSize& );
	static void     polish_width            ( QWidget* const, const int );
	static const QString& num2str          ( const Q_ULLONG, const char = ',' );
	static void    idle                    ();
	static void    clip_path               ( const QFontMetrics& in_fm, const int in_width, QString& in_out_path );
	static QString make_path               ( const QString&, const QString& );
	static void    clip_path               ( const QString&, QString&, QString& );
	static bool    is_dir_ok               ( const QString& );
	static bool    is_white_char           ( const QChar& );
	static bool    remove_white_chars      ( QString& );
	static bool    is_regular_file         ( const QString& );
	static void    auto_rename             ( QString& );
	static bool    is_user_root            ();
	static QString get_fext                ( const QString& );
private:
    static bool   can_not_delete          ( const QString& in_fpath, const int in_type );
};

#endif // INCLUDED_SHARED_H
