/* manager.c generated by valac 0.32.1, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <theme-manager.h>
#include <BudgieSession.h>
#include <gtk/gtk.h>


#define BUDGIE_TYPE_SERVICE_MANAGER (budgie_service_manager_get_type ())
#define BUDGIE_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager))
#define BUDGIE_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))
#define BUDGIE_IS_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_IS_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))

typedef struct _BudgieServiceManager BudgieServiceManager;
typedef struct _BudgieServiceManagerClass BudgieServiceManagerClass;
typedef struct _BudgieServiceManagerPrivate BudgieServiceManagerPrivate;

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _budgie_osd_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_osd_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieServiceManagerRegisterWithSessionData BudgieServiceManagerRegisterWithSessionData;

struct _BudgieServiceManager {
	GObject parent_instance;
	BudgieServiceManagerPrivate * priv;
};

struct _BudgieServiceManagerClass {
	GObjectClass parent_class;
};

struct _BudgieServiceManagerPrivate {
	gchar* current_theme_uri;
	GSettings* settings;
	BudgieThemeManager* theme_manager;
	LibSessionSessionClient* sclient;
	BudgieOSDManager* osd;
};

struct _BudgieServiceManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieServiceManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	GError* e;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	GError * _inner_error_;
};


static gpointer budgie_service_manager_parent_class = NULL;

GType budgie_service_manager_get_type (void) G_GNUC_CONST;
gpointer budgie_osd_manager_ref (gpointer instance);
void budgie_osd_manager_unref (gpointer instance);
GParamSpec* budgie_param_spec_osd_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void budgie_value_set_osd_manager (GValue* value, gpointer v_object);
void budgie_value_take_osd_manager (GValue* value, gpointer v_object);
gpointer budgie_value_get_osd_manager (const GValue* value);
GType budgie_osd_manager_get_type (void) G_GNUC_CONST;
guint budgie_osd_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define BUDGIE_SERVICE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerPrivate))
enum  {
	BUDGIE_SERVICE_MANAGER_DUMMY_PROPERTY
};
BudgieServiceManager* budgie_service_manager_new (void);
BudgieServiceManager* budgie_service_manager_construct (GType object_type);
static void budgie_service_manager_register_with_session (BudgieServiceManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean budgie_service_manager_register_with_session_finish (BudgieServiceManager* self, GAsyncResult* _res_);
static void __lambda10_ (BudgieServiceManager* self, GObject* o, GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
BudgieOSDManager* budgie_osd_manager_new (void);
BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
void budgie_osd_manager_setup_dbus (BudgieOSDManager* self);
static void budgie_service_manager_register_with_session_data_free (gpointer _data);
static gboolean budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_);
static void budgie_service_manager_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda7_ (BudgieServiceManager* self);
static void budgie_service_manager_end_session (BudgieServiceManager* self, gboolean quit);
static void ___lambda7__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda8_ (BudgieServiceManager* self);
static void ___lambda8__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda9_ (BudgieServiceManager* self);
static void ___lambda9__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self);
static void budgie_service_manager_finalize (GObject* obj);


/**
     * Construct a new ServiceManager and initialiase appropriately
     */
static void __lambda10_ (BudgieServiceManager* self, GObject* o, GAsyncResult* res) {
	gboolean success = FALSE;
	GAsyncResult* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = budgie_service_manager_register_with_session_finish (self, _tmp0_);
	success = _tmp1_;
	_tmp2_ = success;
	if (!_tmp2_) {
		g_message ("manager.vala:38: Failed to register with Session manager");
	}
}


static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda10_ ((BudgieServiceManager*) self, source_object, res);
	g_object_unref (self);
}


BudgieServiceManager* budgie_service_manager_construct (GType object_type) {
	BudgieServiceManager * self = NULL;
	BudgieThemeManager* _tmp0_ = NULL;
	BudgieOSDManager* _tmp1_ = NULL;
	BudgieOSDManager* _tmp2_ = NULL;
	self = (BudgieServiceManager*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp0_;
	budgie_service_manager_register_with_session (self, ___lambda10__gasync_ready_callback, g_object_ref (self));
	_tmp1_ = budgie_osd_manager_new ();
	_budgie_osd_manager_unref0 (self->priv->osd);
	self->priv->osd = _tmp1_;
	_tmp2_ = self->priv->osd;
	budgie_osd_manager_setup_dbus (_tmp2_);
	return self;
}


BudgieServiceManager* budgie_service_manager_new (void) {
	return budgie_service_manager_construct (BUDGIE_TYPE_SERVICE_MANAGER);
}


static void budgie_service_manager_register_with_session_data_free (gpointer _data) {
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieServiceManagerRegisterWithSessionData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void budgie_service_manager_register_with_session (BudgieServiceManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieServiceManagerRegisterWithSessionData* _data_;
	BudgieServiceManager* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgieServiceManagerRegisterWithSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_service_manager_register_with_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_service_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_service_manager_register_with_session_co (_data_);
}


static gboolean budgie_service_manager_register_with_session_finish (BudgieServiceManager* self, GAsyncResult* _res_) {
	gboolean result;
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Attempt registration with the Session Manager
     */
static void budgie_service_manager_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_service_manager_register_with_session_co (_data_);
}


static void __lambda7_ (BudgieServiceManager* self) {
	budgie_service_manager_end_session (self, FALSE);
}


static void ___lambda7__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda7_ ((BudgieServiceManager*) self);
}


static void __lambda8_ (BudgieServiceManager* self) {
	budgie_service_manager_end_session (self, FALSE);
}


static void ___lambda8__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda8_ ((BudgieServiceManager*) self);
}


static void __lambda9_ (BudgieServiceManager* self) {
	budgie_service_manager_end_session (self, TRUE);
}


static void ___lambda9__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self) {
	__lambda9_ ((BudgieServiceManager*) self);
}


static gboolean budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		lib_session_register_with_session ("budgie-daemon", budgie_service_manager_register_with_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
		_g_object_unref0 (_data_->self->priv->sclient);
		_data_->self->priv->sclient = _data_->_tmp0_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp1_, "query-end-session", (GCallback) ___lambda7__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "end-session", (GCallback) ___lambda8__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "stop", (GCallback) ___lambda9__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Properly shutdown when asked to
     */
static void budgie_service_manager_end_session (BudgieServiceManager* self, gboolean quit) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = quit;
	if (_tmp0_) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp1_ = NULL;
		_tmp1_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp1_, TRUE, "", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("manager.vala:80: Unable to respond to session manager! %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_service_manager_class_init (BudgieServiceManagerClass * klass) {
	budgie_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieServiceManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_service_manager_finalize;
}


static void budgie_service_manager_instance_init (BudgieServiceManager * self) {
	self->priv = BUDGIE_SERVICE_MANAGER_GET_PRIVATE (self);
}


static void budgie_service_manager_finalize (GObject* obj) {
	BudgieServiceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager);
	_g_free0 (self->priv->current_theme_uri);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->sclient);
	_budgie_osd_manager_unref0 (self->priv->osd);
	G_OBJECT_CLASS (budgie_service_manager_parent_class)->finalize (obj);
}


/**
 * Main lifecycle management, handle all the various session and GTK+ bits
 */
GType budgie_service_manager_get_type (void) {
	static volatile gsize budgie_service_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_service_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieServiceManager), 0, (GInstanceInitFunc) budgie_service_manager_instance_init, NULL };
		GType budgie_service_manager_type_id;
		budgie_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieServiceManager", &g_define_type_info, 0);
		g_once_init_leave (&budgie_service_manager_type_id__volatile, budgie_service_manager_type_id);
	}
	return budgie_service_manager_type_id__volatile;
}



