/*
 * $Id: depconv.c,v 1.4 2003/09/25 15:33:46 jmmv Exp $
 *
 * buildtool
 * Copyright (c) 2003 Julio M. Merino Vidal
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <config.h>

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef LINE_MAX
#define LINE_MAX 1024
#endif

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

int
main(void)
{
	char line[LINE_MAX];
	char word[PATH_MAX];
	size_t len;

	while (fgets(line, LINE_MAX, stdin) != NULL) {
		char *ptr;
		int eot;

		ptr = line;
		eot = 1;
		while (*ptr == ' ' || *ptr == '\t') ptr++;
		while (sscanf(ptr, "%s", word) > 0) {
			len = strlen(word);
			ptr += len;
			while (*ptr == ' ' || *ptr == '\t') ptr++;

			if (word[len - 1] == ':') {
				word[len - 1] = '\0';
				printf("target_%s() {\n", word);
				printf("    BT_TYPE=\"convert\"\n");
				printf("    BT_DEPENDS=\"");
			} else if (len == 1 && word[0] == '\\') {
				printf(" \\\n        ");
				eot = 0;
			} else {
				printf("%s ", word);
			}
		}

		if (eot)
			printf("\"\n}\n");
	}

	if (ferror(stdin)) {
		perror("depconv");
		exit(EXIT_FAILURE);
	}

	return EXIT_SUCCESS;
}
