package buoy.widget;

import buoy.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A BButton is a pushbutton Widget.  Its appearance can be customized by setting the text and/or image which
 * appears on it.
 * <p>
 * In addition to the event types generated by all Widgets, BButtons generate the following event types:
 * <ul>
 * <li>{@link buoy.event.CommandEvent CommandEvent}</li>
 * </ul>
 *
 * @author Peter Eastman
 */

public class BButton extends Widget
{
  /**
   * Create a new BButton with no set text or image.
   */
  
  public BButton()
  {
    component = createComponent();
    ((JButton) component).addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent ev)
      {
        dispatchEvent(new CommandEvent(BButton.this, ev.getWhen(), ev.getModifiers(), ((JButton) component).getActionCommand()));
      }
    });
  }
  
  /**
   * Create a new BButton.
   *
   * @param text      the text to display on the button
   */
  
  public BButton(String text)
  {
    this();
    ((JButton) component).setText(text);
  }

  /**
   * Create a new BButton.
   *
   * @param icon      the image to display on the button
   */
  
  public BButton(Icon icon)
  {
    this();
    ((JButton) component).setIcon(icon);
  }

  /**
   * Create a new BButton.
   *
   * @param text      the text to display on the button
   * @param icon      the image to display on the button
   */
  
  public BButton(String text, Icon icon)
  {
    this();
    ((JButton) component).setText(text);
    ((JButton) component).setIcon(icon);
  }
  
  /**
   * Create the JButton which serves as this Widget's Component.  This method is protected so that
   * subclasses can override it.
   */
  
  protected JButton createComponent()
  {
    return new JButton();
  }

  /**
   * Get the text being displayed on the button.  This may be null.
   */
  
  public String getText()
  {
    return ((JButton) component).getText();
  }

  /**
   * Set the text being displayed on the button.  This may be null.
   */
  
  public void setText(String text)
  {
    ((JButton) component).setText(text);
    invalidateSize();
  }

  /**
   * Get the image being displayed on the button.  This may be null.
   */
  
  public Icon getIcon()
  {
    return ((JButton) component).getIcon();
  }

  /**
   * Set the image being displayed on the button.  This may be null.
   */
  
  public void setIcon(Icon icon)
  {
    ((JButton) component).setIcon(icon);
    invalidateSize();
  }

  /**
   * Get the "action command" which will be sent in a CommandEvent when this button is pressed.
   */
  
  public String getActionCommand()
  {
    return ((JButton) component).getActionCommand();
  }

  /**
   * Set the "action command" which will be sent in a CommandEvent when this button is pressed.
   */
  
  public void setActionCommand(String command)
  {
    ((JButton) component).setActionCommand(command);
  }

  /**
   * Get the largest size at which this Widget can reasonably be drawn.  When a WidgetContainer lays out
   * its contents, it will attempt never to make this Widget larger than its maximum size.
   */
  
  public Dimension getMaximumSize()
  {
    return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
  }
}